/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source;

import ch.kk7.confij.source.ConfijSource;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public interface ConfijSourceBuilder {
    public Optional<ConfijSource> fromURI(URIish var1);

    public static class URIish {
        private final String scheme;
        @NonNull
        private final String schemeSpecificPart;
        private final String fragment;

        public static URIish create(@NonNull String uri) {
            String fragment;
            String path;
            String scheme;
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            String[] schemeParts = uri.split(":", 2);
            if (schemeParts.length == 1) {
                scheme = null;
                path = schemeParts[0];
            } else {
                scheme = schemeParts[0];
                path = schemeParts[1];
            }
            String[] pathParts = path.split("#", 2);
            if (pathParts.length == 1) {
                fragment = null;
            } else {
                path = pathParts[0];
                fragment = pathParts[1];
            }
            return new URIish(scheme, path, fragment);
        }

        public URL toURL() throws MalformedURLException {
            try {
                return new URI(this.scheme, this.schemeSpecificPart, this.fragment).toURL();
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }

        @Generated
        public URIish(String scheme, @NonNull String schemeSpecificPart, String fragment) {
            if (schemeSpecificPart == null) {
                throw new NullPointerException("schemeSpecificPart is marked non-null but is null");
            }
            this.scheme = scheme;
            this.schemeSpecificPart = schemeSpecificPart;
            this.fragment = fragment;
        }

        @Generated
        public String getScheme() {
            return this.scheme;
        }

        @NonNull
        @Generated
        public String getSchemeSpecificPart() {
            return this.schemeSpecificPart;
        }

        @Generated
        public String getFragment() {
            return this.fragment;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof URIish)) {
                return false;
            }
            URIish other = (URIish)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$scheme = this.getScheme();
            String other$scheme = other.getScheme();
            if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
                return false;
            }
            String this$schemeSpecificPart = this.getSchemeSpecificPart();
            String other$schemeSpecificPart = other.getSchemeSpecificPart();
            if (this$schemeSpecificPart == null ? other$schemeSpecificPart != null : !this$schemeSpecificPart.equals(other$schemeSpecificPart)) {
                return false;
            }
            String this$fragment = this.getFragment();
            String other$fragment = other.getFragment();
            return !(this$fragment == null ? other$fragment != null : !this$fragment.equals(other$fragment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof URIish;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scheme = this.getScheme();
            result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
            String $schemeSpecificPart = this.getSchemeSpecificPart();
            result = result * 59 + ($schemeSpecificPart == null ? 43 : $schemeSpecificPart.hashCode());
            String $fragment = this.getFragment();
            result = result * 59 + ($fragment == null ? 43 : $fragment.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConfijSourceBuilder.URIish(scheme=" + this.getScheme() + ", schemeSpecificPart=" + this.getSchemeSpecificPart() + ", fragment=" + this.getFragment() + ")";
        }
    }
}

