/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline;

import ch.kk7.confij.binding.BindingResult;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import ch.kk7.confij.validation.ConfijValidator;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class ConfijPipelineImpl<T>
implements ConfijPipeline<T> {
    @NonNull
    private final List<ConfijSource> sources;
    @NonNull
    private final ConfijSource defaultSource;
    @NonNull
    private final ConfijValidator<T> validator;
    @NonNull
    private final ConfigBinding<T> configBinding;
    @NonNull
    private final NodeDefinition format;

    protected ConfijNode newDefaultConfig() {
        ConfijNode defaultsOnly = ConfijNode.newRootFor(this.format);
        this.defaultSource.override(defaultsOnly);
        return defaultsOnly;
    }

    protected ConfijNode readConfigToNode() {
        ConfijNode rootNode = this.newDefaultConfig();
        for (ConfijSource source : this.sources) {
            source.override(rootNode);
            this.defaultSource.override(rootNode);
        }
        return rootNode;
    }

    protected BindingResult<T> bind(ConfijNode rootNode) {
        return this.configBinding.bind(rootNode);
    }

    @Override
    public T build() {
        ConfijNode simpleConfig = this.readConfigToNode();
        BindingResult<T> bindingResult = this.bind(simpleConfig);
        this.validator.validate(bindingResult);
        return bindingResult.getValue();
    }

    @Generated
    public ConfijPipelineImpl(@NonNull List<ConfijSource> sources, @NonNull ConfijSource defaultSource, @NonNull ConfijValidator<T> validator, @NonNull ConfigBinding<T> configBinding, @NonNull NodeDefinition format) {
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        if (defaultSource == null) {
            throw new NullPointerException("defaultSource is marked non-null but is null");
        }
        if (validator == null) {
            throw new NullPointerException("validator is marked non-null but is null");
        }
        if (configBinding == null) {
            throw new NullPointerException("configBinding is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.sources = sources;
        this.defaultSource = defaultSource;
        this.validator = validator;
        this.configBinding = configBinding;
        this.format = format;
    }

    @NonNull
    @Generated
    public List<ConfijSource> getSources() {
        return this.sources;
    }

    @NonNull
    @Generated
    public ConfijSource getDefaultSource() {
        return this.defaultSource;
    }

    @NonNull
    @Generated
    public ConfijValidator<T> getValidator() {
        return this.validator;
    }

    @NonNull
    @Generated
    public ConfigBinding<T> getConfigBinding() {
        return this.configBinding;
    }

    @NonNull
    @Generated
    public NodeDefinition getFormat() {
        return this.format;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfijPipelineImpl)) {
            return false;
        }
        ConfijPipelineImpl other = (ConfijPipelineImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ConfijSource> this$sources = this.getSources();
        List<ConfijSource> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        ConfijSource this$defaultSource = this.getDefaultSource();
        ConfijSource other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        ConfijValidator<T> this$validator = this.getValidator();
        ConfijValidator<T> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        ConfigBinding<T> this$configBinding = this.getConfigBinding();
        ConfigBinding<T> other$configBinding = other.getConfigBinding();
        if (this$configBinding == null ? other$configBinding != null : !this$configBinding.equals(other$configBinding)) {
            return false;
        }
        NodeDefinition this$format = this.getFormat();
        NodeDefinition other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)this$format).equals(other$format));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfijPipelineImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ConfijSource> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        ConfijSource $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        ConfijValidator<T> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        ConfigBinding<T> $configBinding = this.getConfigBinding();
        result = result * 59 + ($configBinding == null ? 43 : $configBinding.hashCode());
        NodeDefinition $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfijPipelineImpl(sources=" + this.getSources() + ", defaultSource=" + this.getDefaultSource() + ", validator=" + this.getValidator() + ", configBinding=" + this.getConfigBinding() + ", format=" + this.getFormat() + ")";
    }
}

