/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.tree;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.tree.NodeBindingContext;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class NodeDefinition {
    @NonNull
    private final NodeBindingContext nodeBindingContext;

    public boolean isValueHolder() {
        return false;
    }

    @NonNull
    public abstract NodeDefinition definitionForChild(String var1);

    @NonNull
    public Set<String> getMandatoryKeys() {
        return Collections.emptySet();
    }

    @Generated
    public NodeDefinition(@NonNull NodeBindingContext nodeBindingContext) {
        if (nodeBindingContext == null) {
            throw new NullPointerException("nodeBindingContext is marked non-null but is null");
        }
        this.nodeBindingContext = nodeBindingContext;
    }

    @NonNull
    @Generated
    public NodeBindingContext getNodeBindingContext() {
        return this.nodeBindingContext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeDefinition)) {
            return false;
        }
        NodeDefinition other = (NodeDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeBindingContext this$nodeBindingContext = this.getNodeBindingContext();
        NodeBindingContext other$nodeBindingContext = other.getNodeBindingContext();
        return !(this$nodeBindingContext == null ? other$nodeBindingContext != null : !((Object)this$nodeBindingContext).equals(other$nodeBindingContext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NodeDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeBindingContext $nodeBindingContext = this.getNodeBindingContext();
        result = result * 59 + ($nodeBindingContext == null ? 43 : ((Object)$nodeBindingContext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NodeDefinition(nodeBindingContext=" + this.getNodeBindingContext() + ")";
    }

    public static class NodeDefinitionMap
    extends NodeDefinition {
        private final NodeDefinition anyChild;
        private final Map<String, NodeDefinition> children;

        protected NodeDefinitionMap(NodeBindingContext nodeBindingContext, NodeDefinition anyChild, Map<String, NodeDefinition> children) {
            super(nodeBindingContext);
            this.anyChild = anyChild;
            if (children.containsValue(null)) {
                throw new IllegalArgumentException("invalid null value in " + children);
            }
            this.children = Collections.unmodifiableMap(children);
        }

        public static NodeDefinitionMap fixedKeysMap(NodeBindingContext nodeBindingContext, Map<String, NodeDefinition> children) {
            return new NodeDefinitionMap(nodeBindingContext, null, children);
        }

        public static NodeDefinitionMap anyKeyMap(NodeBindingContext nodeBindingContext, NodeDefinition anyChild) {
            return new NodeDefinitionMap(nodeBindingContext, Objects.requireNonNull(anyChild), Collections.emptyMap());
        }

        @Override
        @NonNull
        public NodeDefinition definitionForChild(String configKey) {
            if (this.children.containsKey(configKey)) {
                return this.children.get(configKey);
            }
            if (this.anyChild != null) {
                return this.anyChild;
            }
            throw new ConfijBindingException("invalid config key: map-like format doesn't allow key '{}', allowed are: {}", configKey, this.children.keySet());
        }

        @Override
        @NonNull
        public Set<String> getMandatoryKeys() {
            return this.children.keySet();
        }

        @Override
        @Generated
        public String toString() {
            return "NodeDefinition.NodeDefinitionMap(anyChild=" + this.anyChild + ", children=" + this.children + ")";
        }
    }

    public static class NodeDefinitionList
    extends NodeDefinition {
        private final NodeDefinition anyChild;

        public NodeDefinitionList(NodeBindingContext nodeBindingContext, NodeDefinition anyChild) {
            super(nodeBindingContext);
            this.anyChild = Objects.requireNonNull(anyChild);
        }

        @Override
        @NonNull
        public NodeDefinition definitionForChild(String configKey) {
            int index;
            try {
                index = Integer.parseInt(configKey);
            }
            catch (NumberFormatException e) {
                throw new ConfijBindingException("invalid config key, expected an integer, but found {}", configKey, e);
            }
            if (index < 0) {
                throw new ConfijBindingException("invalid config key, expected a positive number, but found {}", index);
            }
            return this.anyChild;
        }

        @Override
        @Generated
        public String toString() {
            return "NodeDefinition.NodeDefinitionList(anyChild=" + this.anyChild + ")";
        }
    }

    public static class NodeDefinitionLeaf
    extends NodeDefinition {
        public NodeDefinitionLeaf(NodeBindingContext nodeBindingContext) {
            super(nodeBindingContext);
        }

        @Override
        @NonNull
        public NodeDefinition definitionForChild(String configKey) {
            throw new ConfijBindingException("a leaf node isn't allowed to have children, not even for '{}'", configKey);
        }

        @Override
        public boolean isValueHolder() {
            return true;
        }

        @Override
        @Generated
        public String toString() {
            return "NodeDefinition.NodeDefinitionLeaf()";
        }
    }
}

