/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.logical;

import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.tree.ConfijNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class OrSource
implements ConfijSource {
    private static final ConfijLogger LOG = ConfijLogger.getLogger(OrSource.class.getName());
    private final List<ConfijSource> orList;

    public OrSource(@NonNull ConfijSource one, @NonNull ConfijSource or, ConfijSource ... orEven) {
        if (one == null) {
            throw new NullPointerException("one is marked non-null but is null");
        }
        if (or == null) {
            throw new NullPointerException("or is marked non-null but is null");
        }
        this.orList = new ArrayList<ConfijSource>();
        this.orList.add(one);
        this.orList.add(or);
        this.orList.addAll(Arrays.asList(orEven));
    }

    @Override
    public void override(ConfijNode rootNode) {
        ArrayList<Exception> pastExceptions = new ArrayList<Exception>();
        for (ConfijSource source : this.orList) {
            ConfijNode copy = rootNode.deepClone();
            try {
                source.override(copy);
            }
            catch (Exception e) {
                pastExceptions.add(e);
                LOG.info("failed reading optional source {}", source, e);
                continue;
            }
            rootNode.overrideWith(copy);
            return;
        }
        ConfijSourceException e = new ConfijSourceException("failed to read any of the sources: {}", this);
        pastExceptions.forEach(e::addSuppressed);
        throw e;
    }

    @Generated
    public String toString() {
        return "OrSource(orList=" + this.orList + ")";
    }
}

