/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.tree;

import ch.kk7.confij.annotation.Default;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.common.ClassToImplCache;
import ch.kk7.confij.template.DefaultResolver;
import ch.kk7.confij.template.VariableResolver;
import java.lang.reflect.AnnotatedElement;
import lombok.Generated;
import lombok.NonNull;

public class NodeBindingContext {
    private final String defaultValue;
    @NonNull
    private final VariableResolver variableResolver;
    @NonNull
    private final ClassToImplCache implCache;

    public static NodeBindingContext newDefaultSettings() {
        ClassToImplCache implCache = new ClassToImplCache();
        return new NodeBindingContext(null, implCache.getInstance(DefaultResolver.class), implCache);
    }

    protected NodeBindingContext withVariableResolverFor(AnnotatedElement element) {
        return this.withVariableResolver(AnnotationUtil.findAnnotation(element, ch.kk7.confij.annotation.VariableResolver.class).map(ch.kk7.confij.annotation.VariableResolver::value).map(x -> this.implCache.getInstance(x, VariableResolver.class)).orElse(this.variableResolver));
    }

    protected NodeBindingContext withDefaultValueFor(AnnotatedElement element) {
        return this.withDefaultValue(AnnotationUtil.findAnnotation(element, Default.class).map(Default::value).orElse(this.defaultValue));
    }

    public NodeBindingContext settingsFor(AnnotatedElement element) {
        return this.withDefaultValueFor(element).withVariableResolverFor(element);
    }

    @Generated
    public NodeBindingContext withDefaultValue(String defaultValue) {
        return this.defaultValue == defaultValue ? this : new NodeBindingContext(defaultValue, this.variableResolver, this.implCache);
    }

    @Generated
    public NodeBindingContext withVariableResolver(@NonNull VariableResolver variableResolver) {
        if (variableResolver == null) {
            throw new NullPointerException("variableResolver is marked non-null but is null");
        }
        return this.variableResolver == variableResolver ? this : new NodeBindingContext(this.defaultValue, variableResolver, this.implCache);
    }

    @Generated
    public NodeBindingContext withImplCache(@NonNull ClassToImplCache implCache) {
        if (implCache == null) {
            throw new NullPointerException("implCache is marked non-null but is null");
        }
        return this.implCache == implCache ? this : new NodeBindingContext(this.defaultValue, this.variableResolver, implCache);
    }

    @Generated
    public String toString() {
        return "NodeBindingContext(defaultValue=" + this.getDefaultValue() + ", variableResolver=" + this.getVariableResolver() + ", implCache=" + this.implCache + ")";
    }

    @Generated
    public NodeBindingContext(String defaultValue, @NonNull VariableResolver variableResolver, @NonNull ClassToImplCache implCache) {
        if (variableResolver == null) {
            throw new NullPointerException("variableResolver is marked non-null but is null");
        }
        if (implCache == null) {
            throw new NullPointerException("implCache is marked non-null but is null");
        }
        this.defaultValue = defaultValue;
        this.variableResolver = variableResolver;
        this.implCache = implCache;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @NonNull
    @Generated
    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }
}

