/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.tree;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.common.ConfijException;
import ch.kk7.confij.tree.NodeDefinition;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class ConfijNode {
    @NonNull
    private final NodeDefinition config;
    @NonNull
    private final Map<String, ConfijNode> children = new LinkedHashMap<String, ConfijNode>();
    @NonNull
    private final ConfijNode root;
    @NonNull
    private final URI uri;
    private String value;

    protected ConfijNode(@NonNull NodeDefinition config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.root = this;
        this.uri = URI.create("config:/");
    }

    protected ConfijNode(NodeDefinition config, ConfijNode parent, String name) {
        this(config, parent.root, parent.uri.resolve(ConfijNode.uriEncode(name) + (config.isValueHolder() ? "" : "/")));
    }

    protected ConfijNode(@NonNull NodeDefinition config, @NonNull ConfijNode root, @NonNull URI uri) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.config = config;
        this.root = root;
        this.uri = uri;
    }

    public static String uriEncode(String key) {
        try {
            return URLEncoder.encode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("cannot URL encode key: " + key, e);
        }
    }

    public static ConfijNode newRootFor(NodeDefinition nodeDefinition) {
        return new ConfijNode(nodeDefinition);
    }

    public ConfijNode deepClone() {
        if (!this.isRootNode()) {
            throw new IllegalArgumentException("cannot clone a non-root node");
        }
        return this.deepClone(null);
    }

    protected ConfijNode deepClone(ConfijNode rootNode) {
        ConfijNode clone = rootNode == null ? new ConfijNode(this.config) : new ConfijNode(this.config, rootNode, this.uri);
        this.children.forEach((k, v) -> clone.children.put((String)k, v.deepClone(rootNode)));
        clone.value = this.value;
        return clone;
    }

    @NonNull
    public ConfijNode resolve(URI target) {
        URI absolute = this.uri.resolve(target);
        URI relativeTarget = this.uri.relativize(absolute);
        if (relativeTarget.equals(absolute)) {
            String targetScheme;
            String rootScheme = this.root.uri.getScheme();
            if (!rootScheme.equals(targetScheme = relativeTarget.getScheme())) {
                throw new ConfijException("unknown scheme '{}', expected is '{}'", targetScheme, rootScheme);
            }
            return this.root.resolve(absolute);
        }
        String targetPath = relativeTarget.getRawPath();
        if ("".equals(targetPath)) {
            return this;
        }
        String firstPart = targetPath.split("/", 2)[0];
        ConfijNode child = this.children.get(firstPart);
        if (child == null) {
            throw new ConfijException("invalid path {}: node {} doesn't have a child named '{}'", target, this.uri, firstPart);
        }
        return child.resolve(absolute);
    }

    protected boolean isRootNode() {
        return this.root == this;
    }

    @NonNull
    public ConfijNode addChild(String key) {
        this.assertBranchNode();
        if (this.children.containsKey(key)) {
            throw new IllegalStateException("node " + this + " already contains a child named '" + key + "'");
        }
        NodeDefinition childConfig = this.config.definitionForChild(key);
        ConfijNode child = new ConfijNode(childConfig, this, key);
        this.children.put(key, child);
        return child;
    }

    @NonNull
    public Map<String, ConfijNode> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public String getValue() {
        if (!this.config.isValueHolder()) {
            throw new ConfijException("cannot get a value from the non-leaf node {}", this);
        }
        return this.value;
    }

    public void setValue(String value) {
        if (!this.config.isValueHolder()) {
            throw new ConfijBindingException("attempted to set a value '{}' on {}, however this node is not a leaf-node and will never accept a value. Maybe you meant one of its mandatory children: {}", value, this, this.config.getMandatoryKeys());
        }
        this.value = value;
    }

    private void assertBranchNode() {
        if (this.config.isValueHolder()) {
            throw new ConfijException("expected a branch-node but this is {}", this);
        }
    }

    public ConfijNode initializeFromMap(Object mapOrString) {
        if (mapOrString instanceof String || mapOrString == null) {
            this.setValue((String)mapOrString);
        } else if (mapOrString instanceof Map) {
            ((Map)mapOrString).forEach((k, v) -> this.addChild((String)k).initializeFromMap(v));
        } else {
            throw new ConfijException("initializeFromMap for unknown type " + mapOrString.getClass());
        }
        return this;
    }

    public void overrideWith(ConfijNode other) {
        if (this.config != other.config) {
            throw new IllegalArgumentException("cannot override with non-equal node");
        }
        this.value = other.value;
        other.children.forEach((otherKey, otherChild) -> {
            ConfijNode child = this.children.containsKey(otherKey) ? this.children.get(otherKey) : this.addChild((String)otherKey);
            child.overrideWith((ConfijNode)otherChild);
        });
    }

    @Generated
    public String toString() {
        return "ConfijNode(uri=" + this.uri + ", value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfijNode)) {
            return false;
        }
        ConfijNode other = (ConfijNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$uri = this.uri;
        URI other$uri = other.uri;
        return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfijNode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public NodeDefinition getConfig() {
        return this.config;
    }
}

