/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.template;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.common.ConfijException;
import ch.kk7.confij.template.VariableResolver;
import ch.kk7.confij.tree.ConfijNode;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public class DefaultResolver
implements VariableResolver {
    private char escapeChar = (char)92;
    private String pathSeparator = ".";
    private final Map<ConfijNode, String> resolvedLeaves = new HashMap<ConfijNode, String>();
    private final Set<ConfijNode> inProgressLeaves = new LinkedHashSet<ConfijNode>();

    @Override
    public String resolveLeaf(ConfijNode leaf) {
        if (leaf.getValue() == null) {
            return null;
        }
        this.clearCache();
        return this.resolveLeafInternal(leaf);
    }

    protected String resolveLeafInternal(ConfijNode leaf) {
        String value = leaf.getValue();
        if (value == null) {
            throw new ConfijBindingException("referenced property {} is null", leaf);
        }
        if (this.resolvedLeaves.containsKey(leaf)) {
            return this.resolvedLeaves.get(leaf);
        }
        if (this.inProgressLeaves.contains(leaf)) {
            throw new ConfijBindingException("circular dependency: cannot resolve leaf value. Call stack: {}", this.inProgressLeaves);
        }
        this.inProgressLeaves.add(leaf);
        String resolvedValue = this.resolveValueInternal(leaf, value);
        this.inProgressLeaves.remove(leaf);
        this.resolvedLeaves.put(leaf, resolvedValue);
        return resolvedValue;
    }

    @Override
    public String resolveValue(ConfijNode baseNode, String value) {
        this.clearCache();
        return this.resolveValueInternal(baseNode, value);
    }

    protected URI pathToUri(String pathToLeaf) {
        String stringUri = Arrays.stream(pathToLeaf.split(Pattern.quote(this.pathSeparator))).map(ConfijNode::uriEncode).collect(Collectors.joining("/"));
        return URI.create(stringUri);
    }

    protected String resolveVariable(ConfijNode baseLeaf, String variableName) {
        String pathToLeaf = this.resolveValueInternal(baseLeaf, variableName);
        return this.resolveStaticForAbsolutePaths(pathToLeaf).orElseGet(() -> {
            URI uriToLeaf = this.pathToUri(pathToLeaf);
            ConfijNode leaf = baseLeaf.resolve(uriToLeaf);
            return this.resolveLeafInternal(leaf);
        });
    }

    protected Optional<String> resolveStaticForAbsolutePaths(String uriStr) {
        URI targetUri = URI.create(uriStr);
        String scheme = targetUri.getScheme();
        if (scheme == null) {
            return Optional.empty();
        }
        String path = targetUri.getSchemeSpecificPart();
        switch (scheme) {
            case "env": {
                return DefaultResolver.mandatory(uriStr, System.getenv(path));
            }
            case "sys": {
                return DefaultResolver.mandatory(uriStr, System.getProperty(path));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> mandatory(String uriStr, String value) {
        if (value == null) {
            throw new ConfijException("templating failed, since we lack a mandatory value for '{}'", uriStr);
        }
        return Optional.of(value);
    }

    protected void clearCache() {
        this.resolvedLeaves.clear();
        this.inProgressLeaves.clear();
    }

    protected String resolveValueInternal(ConfijNode baseNode, String value) {
        boolean isEscape = false;
        boolean wasDollar = false;
        int bracketCount = 0;
        int bracketContentStart = -1;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (isEscape) {
                value = value.substring(0, i - 1) + value.substring(i);
                --i;
                isEscape = false;
                continue;
            }
            if (c == '$') {
                wasDollar = true;
                continue;
            }
            if (c == this.escapeChar) {
                isEscape = true;
                wasDollar = false;
                continue;
            }
            if (wasDollar && c == '{') {
                if (bracketCount == 0) {
                    bracketContentStart = i + 1;
                }
                ++bracketCount;
                wasDollar = false;
                continue;
            }
            if (bracketCount > 0 && c == '}' && --bracketCount == 0) {
                String toResolve = value.substring(bracketContentStart, i);
                String resolved = this.escape(this.resolveVariable(baseNode, toResolve));
                String beforeReplacement = value.substring(0, bracketContentStart - 2);
                String afterReplacement = value.substring(i + 1);
                i = beforeReplacement.length() + resolved.length();
                value = beforeReplacement + resolved + afterReplacement;
            }
            wasDollar = false;
        }
        return value;
    }

    protected String escape(String s) {
        s = s.replace("" + this.escapeChar, "" + this.escapeChar + this.escapeChar);
        return s.replaceAll("\\$\\{", this.escapeChar + "${");
    }

    @Generated
    public String toString() {
        return "DefaultResolver(escapeChar=" + this.escapeChar + ", pathSeparator=" + this.pathSeparator + ", resolvedLeaves=" + this.resolvedLeaves + ", inProgressLeaves=" + this.inProgressLeaves + ")";
    }
}

