/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.source.resource.URLResourceProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Paths;
import lombok.Generated;

public class FileResourceProvider
extends URLResourceProvider {
    public static final String SCHEME = "file";

    @Override
    public String read(URI fileUri) {
        File file;
        String path = fileUri.getSchemeSpecificPart();
        try {
            file = Paths.get(path, new String[0]).toFile();
        }
        catch (Exception e) {
            throw ConfijSourceFetchingException.unableToFetch(path, "not a valid path", new Object[0]);
        }
        if (!file.exists()) {
            throw ConfijSourceFetchingException.unableToFetch(file.getAbsolutePath(), "file does not exist", new Object[0]);
        }
        if (!file.isFile()) {
            throw ConfijSourceFetchingException.unableToFetch(file.getAbsolutePath(), "not a file", new Object[0]);
        }
        if (!file.canRead()) {
            throw ConfijSourceFetchingException.unableToFetch(file.getAbsolutePath(), "cannot read file", new Object[0]);
        }
        try {
            return this.read(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ConfijSourceFetchingException.unableToFetch(file.getAbsolutePath(), "not a valid URL", e);
        }
    }

    @Override
    public boolean canHandle(URI path) {
        return !path.isAbsolute() || SCHEME.equals(path.getScheme());
    }

    @Override
    @Generated
    public String toString() {
        return "FileResourceProvider()";
    }
}

