/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.source.resource.URLResourceProvider;
import java.net.URI;
import java.net.URL;
import lombok.Generated;

public class ClasspathResourceProvider
extends URLResourceProvider {
    public static final String SCHEME = "classpath";

    @Override
    public String read(URI path) {
        URL classpathUrl = ClassLoader.getSystemResource(path.getSchemeSpecificPart());
        if (classpathUrl == null) {
            throw ConfijSourceFetchingException.unableToFetch(path.getSchemeSpecificPart(), "no such file on system classpath", new Object[0]);
        }
        return this.read(classpathUrl);
    }

    @Override
    public boolean canHandle(URI path) {
        return SCHEME.equals(path.getScheme());
    }

    @Override
    @Generated
    public String toString() {
        return "ClasspathResourceProvider()";
    }
}

