/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.source.format.ConfijSourceFormat;
import ch.kk7.confij.source.format.ConfijSourceFormatException;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class PropertiesFormat
implements ConfijSourceFormat {
    @NonNull
    private String separator = ".";
    @NonNull
    private String globalPrefix = "";

    @Override
    public void override(ConfijNode rootNode, String configAsStr) {
        Properties properties = new Properties();
        try (StringReader r = new StringReader(configAsStr);){
            properties.load(r);
        }
        catch (IOException e) {
            throw ConfijSourceFormatException.invalidFormat("properties", "cannot load from string", e);
        }
        this.overrideWithProperties(rootNode, properties);
    }

    protected void overrideWithProperties(ConfijNode simpleConfig, Properties properties) {
        this.overrideWithFlatMap(simpleConfig, properties);
    }

    protected void overrideWithFlatMap(ConfijNode simpleConfig, Map<String, String> map) {
        Object deepMap = this.flatToNestedMapWithPrefix(simpleConfig.getConfig(), map);
        this.overrideWithDeepMap(simpleConfig, deepMap);
    }

    protected void overrideWithDeepMap(ConfijNode node, Object deepMap) {
        ConfijNode newConfig = ConfijNode.newRootFor(node.getConfig()).initializeFromMap(deepMap);
        node.overrideWith(newConfig);
    }

    protected Object flatToNestedMapWithPrefix(NodeDefinition format, Map<String, String> globalMap) {
        if (format.isValueHolder()) {
            return globalMap.get(this.globalPrefix);
        }
        return this.flatToNestedMap(format, this.flatmapPrefixedBy(globalMap, this.globalPrefix));
    }

    protected Function<String, Object> valueMapper(NodeDefinition parentFormat, Map<String, String> map) {
        return k -> {
            NodeDefinition childFormat = parentFormat.definitionForChild((String)k);
            if (childFormat.isValueHolder()) {
                return map.get(k);
            }
            Map<String, String> childMap = this.flatmapPrefixedBy(map, (String)k);
            return this.flatToNestedMap(childFormat, childMap);
        };
    }

    @NonNull
    protected Object flatToNestedMap(NodeDefinition format, Map<String, String> map) {
        return map.keySet().stream().map(key -> key.split(Pattern.quote(this.separator), 2)[0]).distinct().collect(Collectors.toMap(k -> k, this.valueMapper(format, map)));
    }

    @NonNull
    protected Map<String, String> flatmapPrefixedBy(@NonNull Map<String, String> map, @NonNull String prefix) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (prefix.isEmpty()) {
            return map;
        }
        String prefixAndSep = prefix + this.separator;
        if (map.containsKey(prefix)) {
            throw new ConfijSourceFormatException("invalid key '{}' in map {}. Expected are only keys like '{}*'", prefix, map, prefixAndSep);
        }
        return map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefixAndSep)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefixAndSep.length()), Map.Entry::getValue, (x, y) -> x, HashMap::new));
    }

    @Override
    public boolean canHandle(URI path) {
        return path.getSchemeSpecificPart().matches("(?s).+\\.prop(ertie)?s?$");
    }

    @Generated
    public void setSeparator(@NonNull String separator) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        this.separator = separator;
    }

    @Generated
    public void setGlobalPrefix(@NonNull String globalPrefix) {
        if (globalPrefix == null) {
            throw new NullPointerException("globalPrefix is marked non-null but is null");
        }
        this.globalPrefix = globalPrefix;
    }

    @NonNull
    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @NonNull
    @Generated
    public String getGlobalPrefix() {
        return this.globalPrefix;
    }
}

