/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.any;

import ch.kk7.confij.common.ServiceLoaderUtil;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.any.FixedResourceSource;
import ch.kk7.confij.source.format.ConfijSourceFormat;
import ch.kk7.confij.source.resource.ConfijResourceProvider;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class AnyResourceBuilder
implements ConfijSourceBuilder {
    private final List<ConfijResourceProvider> supportedResources = ServiceLoaderUtil.requireInstancesOf(ConfijResourceProvider.class);
    private final List<ConfijSourceFormat> supportedFormats = ServiceLoaderUtil.requireInstancesOf(ConfijSourceFormat.class);

    @Override
    public Optional<ConfijSource> fromURI(URI path) {
        Optional<ConfijResourceProvider> resource = this.supportedResources.stream().filter(r -> r.canHandle(path)).findFirst();
        if (!resource.isPresent()) {
            return Optional.empty();
        }
        return this.supportedFormats.stream().filter(r -> r.canHandle(path)).findFirst().map(format -> new FixedResourceSource(path, (ConfijResourceProvider)resource.get(), (ConfijSourceFormat)format));
    }

    @Generated
    public String toString() {
        return "AnyResourceBuilder(supportedResources=" + this.supportedResources + ", supportedFormats=" + this.supportedFormats + ")";
    }
}

