/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.binding.values.AbstractClassValueMapper;
import ch.kk7.confij.binding.values.DurationMapper;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import java.time.DateTimeException;
import java.time.Period;
import java.time.temporal.ChronoUnit;

public class PeriodMapper
extends AbstractClassValueMapper<Period> {
    public PeriodMapper() {
        super(Period.class);
    }

    @Override
    public ValueMapperInstance<Period> newInstance(BindingType bindingType) {
        return new PeriodMapperInstance();
    }

    public static class PeriodMapperInstance
    implements ValueMapperInstance.NullableValueMapperInstance<Period> {
        public static Period parsePeriod(String s) {
            String unitString = DurationMapper.DurationMapperInstance.getUnits(s);
            String numberString = s.substring(0, s.length() - unitString.length()).trim();
            if (numberString.length() == 0) {
                throw new ConfijBindingException("bad value: cannot convert an empty value to a Period");
            }
            ChronoUnit units = PeriodMapperInstance.stringToChronoUnit(unitString);
            try {
                return PeriodMapperInstance.periodOf(Integer.parseInt(numberString), units);
            }
            catch (NumberFormatException e) {
                throw new ConfijBindingException("Could not parse duration number '{}'", numberString, e);
            }
        }

        private static ChronoUnit stringToChronoUnit(String unitString) {
            if (unitString.length() > 2 && !unitString.endsWith("s")) {
                unitString = unitString + "s";
            }
            switch (unitString) {
                case "": 
                case "d": 
                case "days": {
                    return ChronoUnit.DAYS;
                }
                case "w": 
                case "weeks": {
                    return ChronoUnit.WEEKS;
                }
                case "m": 
                case "mo": 
                case "months": {
                    return ChronoUnit.MONTHS;
                }
                case "y": 
                case "years": {
                    return ChronoUnit.YEARS;
                }
            }
            throw new ConfijBindingException("Could not parse time unit '{}' (try d, w, mo, y)", unitString);
        }

        private static Period periodOf(int n, ChronoUnit unit) {
            if (unit.isTimeBased()) {
                throw new DateTimeException(unit + " cannot be converted to a java.time.Period");
            }
            switch (unit) {
                case DAYS: {
                    return Period.ofDays(n);
                }
                case WEEKS: {
                    return Period.ofWeeks(n);
                }
                case MONTHS: {
                    return Period.ofMonths(n);
                }
                case YEARS: {
                    return Period.ofYears(n);
                }
            }
            throw new DateTimeException(unit + " cannot be converted to a java.time.Period");
        }

        @Override
        public Period fromNonNullString(String string) {
            return PeriodMapperInstance.parsePeriod(string);
        }
    }
}

