/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.values.DateTimeMapper;
import ch.kk7.confij.binding.values.DurationMapper;
import ch.kk7.confij.binding.values.EnumMapper;
import ch.kk7.confij.binding.values.ExplicitMapper;
import ch.kk7.confij.binding.values.PeriodMapper;
import ch.kk7.confij.binding.values.PrimitiveMapperFactory;
import ch.kk7.confij.binding.values.SoloConstructorMapper;
import ch.kk7.confij.binding.values.StaticFunctionMapper;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.common.ClassToImplCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class BindingContext {
    private final ValueMapperFactory forcedMapperFactory;
    @NonNull
    private final List<ValueMapperFactory> mapperFactories;
    @NonNull
    private final Map<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs;
    @NonNull
    private final ClassToImplCache implCache;

    public BindingContext(ValueMapperFactory forcedMapperFactory, @NonNull List<ValueMapperFactory> mapperFactories, @NonNull Map<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs, @NonNull ClassToImplCache implCache) {
        if (mapperFactories == null) {
            throw new NullPointerException("mapperFactories is marked non-null but is null");
        }
        if (factoryConfigs == null) {
            throw new NullPointerException("factoryConfigs is marked non-null but is null");
        }
        if (implCache == null) {
            throw new NullPointerException("implCache is marked non-null but is null");
        }
        this.forcedMapperFactory = forcedMapperFactory;
        this.mapperFactories = Collections.unmodifiableList(mapperFactories);
        this.factoryConfigs = Collections.unmodifiableMap(factoryConfigs);
        this.implCache = implCache;
    }

    public static BindingContext newDefaultContext() {
        List<ValueMapperFactory> mapperFactories = Arrays.asList(ExplicitMapper.forString(), new PrimitiveMapperFactory(), ExplicitMapper.forFile(), ExplicitMapper.forPath(), new EnumMapper(), new DurationMapper(), new PeriodMapper(), new DateTimeMapper(), new StaticFunctionMapper(), new SoloConstructorMapper());
        return new BindingContext(null, mapperFactories, Collections.emptyMap(), new ClassToImplCache());
    }

    public Optional<ValueMapperFactory> getForcedMapperFactory() {
        return Optional.ofNullable(this.forcedMapperFactory);
    }

    public BindingContext withMapperFactory(ValueMapperFactory valueMapperFactory) {
        ArrayList<ValueMapperFactory> factories = new ArrayList<ValueMapperFactory>();
        factories.add(valueMapperFactory);
        factories.addAll(this.mapperFactories);
        return this.withMapperFactories(factories);
    }

    protected BindingContext withMapperFactoryFor(ValueMapper valueMapper, boolean forced) {
        Class<? extends ValueMapperFactory> clazz = valueMapper.value();
        ValueMapperFactory mapperFactory = this.implCache.getInstance(clazz, ValueMapperFactory.class);
        if (forced) {
            return this.withForcedMapperFactory(mapperFactory);
        }
        return this.withMapperFactory(mapperFactory);
    }

    public Optional<Annotation> getFactoryConfigFor(Class<? extends ValueMapperFactory> forClass) {
        return Optional.ofNullable(this.factoryConfigs.get(forClass));
    }

    protected BindingContext withFactoryConfigFor(Class<? extends ValueMapperFactory> forClass, Annotation declaringAnnotation) {
        HashMap<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs = new HashMap<Class<? extends ValueMapperFactory>, Annotation>(this.factoryConfigs);
        factoryConfigs.put(forClass, declaringAnnotation);
        return this.withFactoryConfigs(factoryConfigs);
    }

    public BindingContext settingsFor(AnnotatedElement element, boolean forced) {
        Optional<AnnotationUtil.AnnonResponse<ValueMapper>> declaration = AnnotationUtil.findAnnotationAndDeclaration(element, ValueMapper.class);
        if (declaration.isPresent()) {
            AnnotationUtil.AnnonResponse<ValueMapper> response = declaration.get();
            ValueMapper valueMapper = response.getAnnotationType();
            return this.withFactoryConfigFor(valueMapper.value(), response.getDeclaredAnnotation()).withMapperFactoryFor(valueMapper, forced);
        }
        return this;
    }

    @NonNull
    @Generated
    public Map<Class<? extends ValueMapperFactory>, Annotation> getFactoryConfigs() {
        return this.factoryConfigs;
    }

    @NonNull
    @Generated
    public ClassToImplCache getImplCache() {
        return this.implCache;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindingContext)) {
            return false;
        }
        BindingContext other = (BindingContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<ValueMapperFactory> this$forcedMapperFactory = this.getForcedMapperFactory();
        Optional<ValueMapperFactory> other$forcedMapperFactory = other.getForcedMapperFactory();
        if (this$forcedMapperFactory == null ? other$forcedMapperFactory != null : !((Object)this$forcedMapperFactory).equals(other$forcedMapperFactory)) {
            return false;
        }
        List<ValueMapperFactory> this$mapperFactories = this.getMapperFactories();
        List<ValueMapperFactory> other$mapperFactories = other.getMapperFactories();
        if (this$mapperFactories == null ? other$mapperFactories != null : !((Object)this$mapperFactories).equals(other$mapperFactories)) {
            return false;
        }
        Map<Class<? extends ValueMapperFactory>, Annotation> this$factoryConfigs = this.getFactoryConfigs();
        Map<Class<? extends ValueMapperFactory>, Annotation> other$factoryConfigs = other.getFactoryConfigs();
        if (this$factoryConfigs == null ? other$factoryConfigs != null : !((Object)this$factoryConfigs).equals(other$factoryConfigs)) {
            return false;
        }
        ClassToImplCache this$implCache = this.getImplCache();
        ClassToImplCache other$implCache = other.getImplCache();
        return !(this$implCache == null ? other$implCache != null : !this$implCache.equals(other$implCache));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BindingContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<ValueMapperFactory> $forcedMapperFactory = this.getForcedMapperFactory();
        result = result * 59 + ($forcedMapperFactory == null ? 43 : ((Object)$forcedMapperFactory).hashCode());
        List<ValueMapperFactory> $mapperFactories = this.getMapperFactories();
        result = result * 59 + ($mapperFactories == null ? 43 : ((Object)$mapperFactories).hashCode());
        Map<Class<? extends ValueMapperFactory>, Annotation> $factoryConfigs = this.getFactoryConfigs();
        result = result * 59 + ($factoryConfigs == null ? 43 : ((Object)$factoryConfigs).hashCode());
        ClassToImplCache $implCache = this.getImplCache();
        result = result * 59 + ($implCache == null ? 43 : $implCache.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BindingContext(forcedMapperFactory=" + this.getForcedMapperFactory() + ", mapperFactories=" + this.getMapperFactories() + ", factoryConfigs=" + this.getFactoryConfigs() + ", implCache=" + this.getImplCache() + ")";
    }

    @Generated
    public BindingContext withForcedMapperFactory(ValueMapperFactory forcedMapperFactory) {
        return this.forcedMapperFactory == forcedMapperFactory ? this : new BindingContext(forcedMapperFactory, this.mapperFactories, this.factoryConfigs, this.implCache);
    }

    @Generated
    public BindingContext withMapperFactories(@NonNull List<ValueMapperFactory> mapperFactories) {
        if (mapperFactories == null) {
            throw new NullPointerException("mapperFactories is marked non-null but is null");
        }
        return this.mapperFactories == mapperFactories ? this : new BindingContext(this.forcedMapperFactory, mapperFactories, this.factoryConfigs, this.implCache);
    }

    @Generated
    public BindingContext withFactoryConfigs(@NonNull Map<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs) {
        if (factoryConfigs == null) {
            throw new NullPointerException("factoryConfigs is marked non-null but is null");
        }
        return this.factoryConfigs == factoryConfigs ? this : new BindingContext(this.forcedMapperFactory, this.mapperFactories, factoryConfigs, this.implCache);
    }

    @Generated
    public BindingContext withImplCache(@NonNull ClassToImplCache implCache) {
        if (implCache == null) {
            throw new NullPointerException("implCache is marked non-null but is null");
        }
        return this.implCache == implCache ? this : new BindingContext(this.forcedMapperFactory, this.mapperFactories, this.factoryConfigs, implCache);
    }

    @NonNull
    @Generated
    public List<ValueMapperFactory> getMapperFactories() {
        return this.mapperFactories;
    }
}

