/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij;

import ch.kk7.confij.binding.BindingContext;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.pipeline.ConfijPipelineImpl;
import ch.kk7.confij.pipeline.reload.ConfijReloader;
import ch.kk7.confij.pipeline.reload.ScheduledReloader;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.any.AnySource;
import ch.kk7.confij.source.defaults.DefaultSource;
import ch.kk7.confij.source.logical.MaybeSource;
import ch.kk7.confij.source.logical.OrSource;
import ch.kk7.confij.template.NoopResolver;
import ch.kk7.confij.template.VariableResolver;
import ch.kk7.confij.tree.NodeBindingContext;
import ch.kk7.confij.tree.NodeDefinition;
import ch.kk7.confij.validation.ConfijValidator;
import ch.kk7.confij.validation.ServiceLoaderValidator;
import com.fasterxml.classmate.GenericType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class ConfijBuilder<T> {
    private final Type forType;
    private final List<ConfijSource> sources = new ArrayList<ConfijSource>();
    private ConfijValidator validator = null;
    private NodeBindingContext nodeBindingContext = null;
    private BindingContext bindingContext = null;
    private ConfijReloader<T> reloader = null;

    protected ConfijBuilder(@NonNull Type forType) {
        if (forType == null) {
            throw new NullPointerException("forType is marked non-null but is null");
        }
        this.forType = forType;
    }

    public static <X> ConfijBuilder<X> of(Class<X> forClass) {
        return new ConfijBuilder(forClass);
    }

    public static <X> ConfijBuilder<X> of(GenericType<X> forType) {
        return new ConfijBuilder((Type)forType);
    }

    public ConfijBuilder<T> loadFrom(String ... sourceStr) {
        Stream.of(sourceStr).map(AnySource::new).forEachOrdered(this.sources::add);
        return this;
    }

    public ConfijBuilder<T> loadFrom(ConfijSource ... source) {
        this.sources.addAll(Arrays.asList(source));
        return this;
    }

    public ConfijBuilder<T> loadOptionalFrom(String ... maybeSourceStr) {
        return this.loadFrom(Stream.of(maybeSourceStr).map(AnySource::new).map(MaybeSource::new).collect(Collectors.toList()).toArray(new MaybeSource[0]));
    }

    public ConfijBuilder<T> loadFromFirstOf(String firstSource, String secondSource, String ... otherSources) {
        return this.loadFrom(new OrSource(new AnySource(firstSource), new AnySource(secondSource), Stream.of(otherSources).map(AnySource::new).collect(Collectors.toList()).toArray(new AnySource[0])));
    }

    public ConfijBuilder<T> validateWith(@NonNull ConfijValidator validator) {
        if (validator == null) {
            throw new NullPointerException("validator is marked non-null but is null");
        }
        this.validator = validator;
        return this;
    }

    public ConfijBuilder<T> validationDisabled() {
        return this.validateWith(ConfijValidator.NOOP);
    }

    @NonNull
    protected NodeBindingContext getNodeBindingContext() {
        if (this.nodeBindingContext == null) {
            this.nodeBindingContext = NodeBindingContext.newDefaultSettings();
        }
        return this.nodeBindingContext;
    }

    public ConfijBuilder<T> nodeBindingContext(NodeBindingContext nodeBindingContext) {
        if (this.nodeBindingContext != null) {
            throw new IllegalStateException("unsafe usage of NodeBindingContext after it has been modified already");
        }
        this.nodeBindingContext = nodeBindingContext;
        return this;
    }

    public ConfijBuilder<T> templatingWith(@NonNull VariableResolver variableResolver) {
        if (variableResolver == null) {
            throw new NullPointerException("variableResolver is marked non-null but is null");
        }
        this.nodeBindingContext = this.getNodeBindingContext().withVariableResolver(variableResolver);
        return this;
    }

    public ConfijBuilder<T> templatingDisabled() {
        return this.templatingWith(new NoopResolver());
    }

    public ConfijBuilder<T> globalDefaultValue(String defaultValue) {
        this.nodeBindingContext = this.getNodeBindingContext().withDefaultValue(defaultValue);
        return this;
    }

    @NonNull
    protected BindingContext getBindingContext() {
        if (this.bindingContext == null) {
            this.bindingContext = BindingContext.newDefaultContext();
        }
        return this.bindingContext;
    }

    public ConfijBuilder<T> bindingContext(BindingContext bindingContext) {
        if (this.bindingContext != null) {
            throw new IllegalStateException("unsafe usage of BindingContext after it has been modified already");
        }
        this.bindingContext = bindingContext;
        return this;
    }

    public ConfijBuilder<T> bindValuesWith(ValueMapperFactory valueMapperFactory) {
        this.bindingContext = this.getBindingContext().withMapperFactory(valueMapperFactory);
        return this;
    }

    public <I> ConfijBuilder<T> bindValuesForClassWith(ValueMapperInstance<I> valueMapper, Class<I> forClass) {
        return this.bindValuesWith(ValueMapperFactory.forClass(valueMapper, forClass));
    }

    public ConfijBuilder<T> withReloader(@NonNull ConfijReloader<T> reloader) {
        if (reloader == null) {
            throw new NullPointerException("reloader is marked non-null but is null");
        }
        this.reloader = reloader;
        return this;
    }

    protected ConfijPipeline<T> buildPipeline() {
        this.validator = Optional.ofNullable(this.validator).orElseGet(ServiceLoaderValidator::new);
        ConfigBinder configBinder = new ConfigBinder();
        ConfigBinding<?> configBinding = configBinder.toRootConfigBinding(this.forType, this.getBindingContext());
        NodeDefinition nodeDefinition = configBinding.describe(this.getNodeBindingContext());
        return new ConfijPipelineImpl(this.sources, new DefaultSource(), this.validator, configBinding, nodeDefinition);
    }

    public T build() {
        return this.buildPipeline().build();
    }

    public ConfijReloader<T> buildReloadable() {
        this.reloader = Optional.ofNullable(this.reloader).orElseGet(ScheduledReloader::new);
        this.reloader.initialize(this.buildPipeline());
        return this.reloader;
    }
}

