/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.logical;

import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.tree.ConfijNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class OrSource
implements ConfigSource {
    private final List<ConfigSource> orList;

    public OrSource(@NonNull ConfigSource one, @NonNull ConfigSource or, ConfigSource ... orEven) {
        if (one == null) {
            throw new NullPointerException("one is marked @NonNull but is null");
        }
        if (or == null) {
            throw new NullPointerException("or is marked @NonNull but is null");
        }
        this.orList = new ArrayList<ConfigSource>();
        this.orList.add(one);
        this.orList.add(or);
        this.orList.addAll(Arrays.asList(orEven));
    }

    @Override
    public void override(ConfijNode rootNode) {
        ArrayList<Exception> pastExceptions = new ArrayList<Exception>();
        for (ConfigSource source : this.orList) {
            ConfijNode copy = rootNode.deepClone();
            try {
                source.override(copy);
            }
            catch (Exception e) {
                pastExceptions.add(e);
                continue;
            }
            rootNode.overrideWith(copy);
            return;
        }
        ConfijSourceException e = new ConfijSourceException("failed to read any of the sources: {}", this);
        pastExceptions.forEach(e::addSuppressed);
        throw e;
    }

    @Generated
    public String toString() {
        return "OrSource(orList=" + this.orList + ")";
    }
}

