/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.file.resource;

import ch.kk7.confij.source.file.resource.AbstractResourceProvider;
import ch.kk7.confij.source.file.resource.ResourceFetchingException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Scanner;

public class URLResourceProvider
extends AbstractResourceProvider {
    @Override
    public String read(URI path) {
        try {
            return this.read(path.toURL());
        }
        catch (MalformedURLException e) {
            throw ResourceFetchingException.unableToFetch(path.toString(), "not a valid URL", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String read(URL url) {
        try (InputStream inputStream = Objects.requireNonNull(url, "null URL").openStream();){
            String string = new Scanner(inputStream, this.getCharset().name()).useDelimiter("\\A").next();
            return string;
        }
        catch (IOException e) {
            throw ResourceFetchingException.unableToFetch(url.toString(), "cannot read input stream", e);
        }
    }

    @Override
    public boolean canHandle(URI path) {
        try {
            path.toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }
}

