/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.file.resource;

import ch.kk7.confij.source.file.resource.ResourceFetchingException;
import ch.kk7.confij.source.file.resource.URLResourceProvider;
import java.net.URI;
import java.net.URL;

public class ClasspathResourceProvider
extends URLResourceProvider {
    public static final String SCHEME = "classpath";

    @Override
    public String read(URI path) {
        URL classpathUrl = ClassLoader.getSystemResource(path.getSchemeSpecificPart());
        if (classpathUrl == null) {
            throw ResourceFetchingException.unableToFetch(path.getSchemeSpecificPart(), "no such file on system classpath", new Object[0]);
        }
        return this.read(classpathUrl);
    }

    @Override
    public boolean canHandle(URI path) {
        return SCHEME.equals(path.getScheme());
    }
}

