/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.file;

import ch.kk7.confij.common.ServiceLoaderUtil;
import ch.kk7.confij.source.ConfigSourceBuilder;
import ch.kk7.confij.source.file.FixedResourceSource;
import ch.kk7.confij.source.file.format.ConfijSourceFormat;
import ch.kk7.confij.source.file.resource.ConfijResourceProvider;
import java.net.URI;
import java.util.List;
import java.util.Optional;

public class AnyResourceBuilder
implements ConfigSourceBuilder {
    private final List<ConfijResourceProvider> supportedResources = ServiceLoaderUtil.instancesOf(ConfijResourceProvider.class);
    private final List<ConfijSourceFormat> supportedFormats = ServiceLoaderUtil.instancesOf(ConfijSourceFormat.class);

    public Optional<FixedResourceSource> fromURI(URI path) {
        Optional<ConfijResourceProvider> resource = this.supportedResources.stream().filter(r -> r.canHandle(path)).findFirst();
        if (!resource.isPresent()) {
            return Optional.empty();
        }
        return this.supportedFormats.stream().filter(r -> r.canHandle(path)).findFirst().map(format -> new FixedResourceSource(path, (ConfijResourceProvider)resource.get(), (ConfijSourceFormat)format));
    }
}

