/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline;

import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import ch.kk7.confij.validation.ConfijValidator;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class ConfijPipelineImpl<T>
implements ConfijPipeline<T> {
    @NonNull
    private final List<ConfigSource> sources;
    @NonNull
    private final ConfigSource defaultSource;
    @NonNull
    private final ConfijValidator validator;
    @NonNull
    private final ConfigBinding<T> configBinding;
    @NonNull
    private final NodeDefinition format;

    protected ConfijNode newDefaultConfig() {
        ConfijNode defaultsOnly = ConfijNode.newRootFor(this.format);
        this.defaultSource.override(defaultsOnly);
        return defaultsOnly;
    }

    protected ConfijNode readConfigToNode() {
        ConfijNode rootNode = this.newDefaultConfig();
        for (ConfigSource source : this.sources) {
            source.override(rootNode);
            this.defaultSource.override(rootNode);
        }
        return rootNode;
    }

    protected T bind(ConfijNode rootNode) {
        return this.configBinding.bind(rootNode);
    }

    @Override
    public T build() {
        ConfijNode simpleConfig = this.readConfigToNode();
        T config = this.bind(simpleConfig);
        this.validator.validate(config);
        return config;
    }

    @Generated
    public ConfijPipelineImpl(@NonNull List<ConfigSource> sources, @NonNull ConfigSource defaultSource, @NonNull ConfijValidator validator, @NonNull ConfigBinding<T> configBinding, @NonNull NodeDefinition format) {
        if (sources == null) {
            throw new NullPointerException("sources is marked @NonNull but is null");
        }
        if (defaultSource == null) {
            throw new NullPointerException("defaultSource is marked @NonNull but is null");
        }
        if (validator == null) {
            throw new NullPointerException("validator is marked @NonNull but is null");
        }
        if (configBinding == null) {
            throw new NullPointerException("configBinding is marked @NonNull but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked @NonNull but is null");
        }
        this.sources = sources;
        this.defaultSource = defaultSource;
        this.validator = validator;
        this.configBinding = configBinding;
        this.format = format;
    }
}

