/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class AnnotationUtil {
    public static <A extends Annotation> Optional<AnnonResponse<A>> findAnnotationAndDeclaration(AnnotatedElement annotatedElement, Class<A> annotationType) {
        A annotation = annotatedElement.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return Optional.of(new AnnonResponse<A>((Annotation)annotation, annotation));
        }
        HashSet<Annotation> visited = new HashSet<Annotation>();
        for (Annotation declaredAnn : annotatedElement.getDeclaredAnnotations()) {
            Class<? extends Annotation> declaredType = declaredAnn.annotationType();
            if (AnnotationUtil.isInJavaLangAnnotationPackage(declaredType) || !visited.add(declaredAnn) || (annotation = AnnotationUtil.findAnnotation(declaredType, annotationType, visited)) == null) continue;
            return Optional.of(new AnnonResponse<A>(declaredAnn, annotation));
        }
        return Optional.empty();
    }

    public static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return Optional.ofNullable(AnnotationUtil.findAnnotation(annotatedElement, annotationType, new HashSet<Annotation>()));
    }

    private static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType, Set<Annotation> visited) {
        A annotation = annotatedElement.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation declaredAnn : annotatedElement.getDeclaredAnnotations()) {
            Class<? extends Annotation> declaredType = declaredAnn.annotationType();
            if (AnnotationUtil.isInJavaLangAnnotationPackage(declaredType) || !visited.add(declaredAnn) || (annotation = AnnotationUtil.findAnnotation(declaredType, annotationType, visited)) == null) continue;
            return annotation;
        }
        return null;
    }

    static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && AnnotationUtil.isInJavaLangAnnotationPackage(annotationType.getName());
    }

    public static boolean isInJavaLangAnnotationPackage(String annotationType) {
        return annotationType != null && annotationType.startsWith("java.lang.annotation");
    }

    public static final class AnnonResponse<A extends Annotation> {
        private final Annotation declaredAnnotation;
        private final A annotationType;

        @Generated
        public AnnonResponse(Annotation declaredAnnotation, A annotationType) {
            this.declaredAnnotation = declaredAnnotation;
            this.annotationType = annotationType;
        }

        @Generated
        public Annotation getDeclaredAnnotation() {
            return this.declaredAnnotation;
        }

        @Generated
        public A getAnnotationType() {
            return this.annotationType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnonResponse)) {
                return false;
            }
            AnnonResponse other = (AnnonResponse)o;
            Annotation this$declaredAnnotation = this.getDeclaredAnnotation();
            Annotation other$declaredAnnotation = other.getDeclaredAnnotation();
            if (this$declaredAnnotation == null ? other$declaredAnnotation != null : !((Object)this$declaredAnnotation).equals(other$declaredAnnotation)) {
                return false;
            }
            A this$annotationType = this.getAnnotationType();
            A other$annotationType = other.getAnnotationType();
            return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Annotation $declaredAnnotation = this.getDeclaredAnnotation();
            result = result * 59 + ($declaredAnnotation == null ? 43 : ((Object)$declaredAnnotation).hashCode());
            A $annotationType = this.getAnnotationType();
            result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnnotationUtil.AnnonResponse(declaredAnnotation=" + this.getDeclaredAnnotation() + ", annotationType=" + this.getAnnotationType() + ")";
        }
    }
}

