/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import java.util.Optional;
import lombok.NonNull;

@FunctionalInterface
public interface ValueMapperFactory {
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType var1);

    public static <T> ValueMapperFactory always(@NonNull ValueMapperInstance<T> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked @NonNull but is null");
        }
        return bindingType -> Optional.of(mapper);
    }

    public static <T> ValueMapperFactory forClass(@NonNull ValueMapperInstance<T> mapper, @NonNull Class<T> forClass) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked @NonNull but is null");
        }
        if (forClass == null) {
            throw new NullPointerException("forClass is marked @NonNull but is null");
        }
        return bindingType -> {
            if (bindingType.getResolvedType().getErasedType().equals(forClass)) {
                return Optional.of(mapper);
            }
            return Optional.empty();
        };
    }
}

