/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.binding.BindingException;
import ch.kk7.confij.binding.intf.DefaultMethodHandler;
import ch.kk7.confij.binding.intf.InterfaceProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class IntfaceInvocationHandler
implements InvocationHandler {
    private final String className;
    private final Map<Method, Object> methodToValues;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return this.invokeObjectClass(proxy, method, args);
        }
        if (InterfaceProxyBuilder.ConfijHandled.class.equals(method.getDeclaringClass())) {
            return this.invokeConfijHandled(proxy, method, args);
        }
        if (this.methodToValues.containsKey(method)) {
            return this.methodToValues.get(method);
        }
        if (method.isDefault()) {
            return this.invokeDefault(proxy, method, args);
        }
        throw new BindingException("cannot call method '{}' as it was not initialized. initialized are: {}", method, this.methodToValues.keySet());
    }

    protected Object invokeObjectClass(Object proxy, Method method, Object[] args) throws Throwable {
        if ("toString".equals(method.getName())) {
            return this.intfToString();
        }
        if ("equals".equals(method.getName())) {
            return this.intfEquals(proxy, args[0]);
        }
        if ("hashCode".equals(method.getName())) {
            return this.methodToValues.hashCode();
        }
        return method.invoke((Object)this, args);
    }

    protected Object invokeConfijHandled(Object proxy, Method method, Object[] args) throws Throwable {
        return this.methodToValues;
    }

    @Override
    protected Object invokeDefault(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return DefaultMethodHandler.invokeDefaultMethod(proxy, method, args);
        }
        catch (DefaultMethodHandler.DefaultMethodException e) {
            throw e.getThrowable();
        }
    }

    protected String intfToString() {
        StringBuilder sb = new StringBuilder(this.className).append("{");
        this.methodToValues.forEach((k, v) -> sb.append(k.getName()).append("=").append(v).append(", "));
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }

    protected boolean intfEquals(Object proxy, Object o) {
        if (proxy == o) {
            return true;
        }
        if (!(o instanceof InterfaceProxyBuilder.ConfijHandled)) {
            return false;
        }
        InterfaceProxyBuilder.ConfijHandled that = (InterfaceProxyBuilder.ConfijHandled)o;
        return Objects.equals(this.methodToValues, that.methodToValue());
    }

    @Generated
    public IntfaceInvocationHandler(String className, Map<Method, Object> methodToValues) {
        this.className = className;
        this.methodToValues = methodToValues;
    }

    @Generated
    public String toString() {
        return "IntfaceInvocationHandler(className=" + this.className + ", methodToValues=" + this.methodToValues + ")";
    }
}

