/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding;

import ch.kk7.confij.binding.BindingContext;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.ConfigBindingFactory;
import ch.kk7.confij.binding.array.ArrayBindingFactory;
import ch.kk7.confij.binding.collection.CollectionBindingFactory;
import ch.kk7.confij.binding.intf.InterfaceBindingFactory;
import ch.kk7.confij.binding.leaf.ForcedLeafBindingFactory;
import ch.kk7.confij.binding.leaf.LeafBindingFactory;
import ch.kk7.confij.binding.map.MapBindingFactory;
import ch.kk7.confij.common.ConfijException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ConfigBinder {
    private List<ConfigBindingFactory<?>> descriptionFactories = new ArrayList();

    public ConfigBinder() {
        this.descriptionFactories.add(new ForcedLeafBindingFactory());
        this.descriptionFactories.add(new ArrayBindingFactory());
        this.descriptionFactories.add(new CollectionBindingFactory());
        this.descriptionFactories.add(new MapBindingFactory());
        this.descriptionFactories.add(new InterfaceBindingFactory());
        this.descriptionFactories.add(new LeafBindingFactory());
    }

    public ConfigBinding<?> toRootConfigBinding(Type forType, BindingContext bindingContext) {
        return this.toConfigBinding(BindingType.newBindingType(forType, bindingContext));
    }

    public ConfigBinding<?> toConfigBinding(BindingType bindingType) {
        return this.descriptionFactories.stream().map(configDescriptionFactory -> configDescriptionFactory.maybeCreate(bindingType, this)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new ConfijException("Unable to bind to type '{}'. This type cannot be handled by any of the factories. Either replace this type definition or add a custom {} to {}.", bindingType.getResolvedType(), ConfigBindingFactory.class.getName(), ConfigBinder.class));
    }
}

