/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.logical;

import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.tree.ConfijNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public final class OrSource
implements ConfigSource {
    private final List<ConfigSource> orList;

    public OrSource(@NonNull ConfigSource one, @NonNull ConfigSource or, ConfigSource ... orEven) {
        if (one == null) {
            throw new NullPointerException("one is marked @NonNull but is null");
        }
        if (or == null) {
            throw new NullPointerException("or is marked @NonNull but is null");
        }
        this.orList = new ArrayList<ConfigSource>();
        this.orList.add(one);
        this.orList.add(or);
        this.orList.addAll(Arrays.asList(orEven));
    }

    @Override
    public void override(ConfijNode rootNode) {
        ArrayList<Exception> pastExceptions = new ArrayList<Exception>();
        for (ConfigSource source : this.orList) {
            ConfijNode copy = rootNode.deepClone();
            try {
                source.override(copy);
            }
            catch (Exception e) {
                pastExceptions.add(e);
                continue;
            }
            rootNode.overrideWith(copy);
            return;
        }
        ConfijSourceException e = new ConfijSourceException("failed to read any of the sources: {}", this);
        pastExceptions.forEach(e::addSuppressed);
        throw e;
    }

    public List<ConfigSource> getOrList() {
        return this.orList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrSource)) {
            return false;
        }
        OrSource other = (OrSource)o;
        List<ConfigSource> this$orList = this.getOrList();
        List<ConfigSource> other$orList = other.getOrList();
        return !(this$orList == null ? other$orList != null : !((Object)this$orList).equals(other$orList));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ConfigSource> $orList = this.getOrList();
        result = result * 59 + ($orList == null ? 43 : ((Object)$orList).hashCode());
        return result;
    }

    public String toString() {
        return "OrSource(orList=" + this.getOrList() + ")";
    }
}

