/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.logical;

import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.source.tree.ConfijNode;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public final class MaybeSource
implements ConfigSource {
    @NonNull
    private final ConfigSource maybeSource;

    @Override
    public void override(ConfijNode rootNode) {
        ConfijNode copy = rootNode.deepClone();
        try {
            this.maybeSource.override(copy);
        }
        catch (Exception e) {
            Logger.getLogger(MaybeSource.class.getName()).log(Level.INFO, "failed reading optional source " + this.maybeSource, e);
        }
        rootNode.overrideWith(copy);
    }

    public MaybeSource(@NonNull ConfigSource maybeSource) {
        if (maybeSource == null) {
            throw new NullPointerException("maybeSource is marked @NonNull but is null");
        }
        this.maybeSource = maybeSource;
    }

    @NonNull
    public ConfigSource getMaybeSource() {
        return this.maybeSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaybeSource)) {
            return false;
        }
        MaybeSource other = (MaybeSource)o;
        ConfigSource this$maybeSource = this.getMaybeSource();
        ConfigSource other$maybeSource = other.getMaybeSource();
        return !(this$maybeSource == null ? other$maybeSource != null : !this$maybeSource.equals(other$maybeSource));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigSource $maybeSource = this.getMaybeSource();
        result = result * 59 + ($maybeSource == null ? 43 : $maybeSource.hashCode());
        return result;
    }

    public String toString() {
        return "MaybeSource(maybeSource=" + this.getMaybeSource() + ")";
    }
}

