/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.file.resource;

import ch.kk7.confij.source.file.resource.ResourceFetchingException;
import ch.kk7.confij.source.file.resource.URLResourceProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Paths;

public class FileResourceProvider
extends URLResourceProvider {
    public static final String SCHEME = "file";

    @Override
    public String read(URI maybeFileUri) {
        File file;
        String path = maybeFileUri.getSchemeSpecificPart();
        try {
            file = Paths.get(path, new String[0]).toFile();
        }
        catch (Exception e) {
            throw ResourceFetchingException.unableToFetch(path, "not a valid path", new Object[0]);
        }
        if (!file.exists()) {
            throw ResourceFetchingException.unableToFetch(file.getAbsolutePath(), "file does not exist", new Object[0]);
        }
        if (!file.isFile()) {
            throw ResourceFetchingException.unableToFetch(file.getAbsolutePath(), "not a file", new Object[0]);
        }
        if (!file.canRead()) {
            throw ResourceFetchingException.unableToFetch(file.getAbsolutePath(), "cannot read file", new Object[0]);
        }
        try {
            return this.read(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ResourceFetchingException.unableToFetch(file.getAbsolutePath(), "not a valid URL", e);
        }
    }

    @Override
    public boolean canHandle(URI path) {
        return !path.isAbsolute() || SCHEME.equals(path.getScheme());
    }
}

