/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.defaults;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.source.tree.ConfijNode;
import java.util.Set;

public class DefaultSource
implements ConfigSource {
    @Override
    public void override(ConfijNode rootNode) {
        if (rootNode.getConfig().isValueHolder()) {
            this.overrideLeaf(rootNode);
        } else {
            this.overrideBranch(rootNode);
        }
    }

    protected void overrideLeaf(ConfijNode leafNode) {
        String currentValue = leafNode.getValue();
        if (currentValue == null) {
            leafNode.setValue(leafNode.getConfig().getFormatSettings().getDefaultValue());
        }
    }

    protected void overrideBranch(ConfijNode confijBranch) {
        Set<String> existingKeys = confijBranch.getChildren().keySet();
        confijBranch.getChildren().values().forEach(this::override);
        confijBranch.getConfig().getMandatoryKeys().stream().filter(Util.not(existingKeys::contains)).map(confijBranch::addChild).forEach(this::override);
    }
}

