/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source;

import ch.kk7.confij.common.ServiceLoaderUtil;
import ch.kk7.confij.format.resolve.VariableResolver;
import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.source.ConfigSourceBuilder;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.tree.ConfijNode;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AnySource
implements ConfigSource {
    private final List<ConfigSourceBuilder> sourceBuilders;
    private final String pathTemplate;
    private VariableResolver resolverOverride;

    public AnySource(String pathTemplate) {
        this.pathTemplate = Objects.requireNonNull(pathTemplate);
        this.sourceBuilders = ServiceLoaderUtil.instancesOf(ConfigSourceBuilder.class);
    }

    private VariableResolver getResolver(ConfijNode rootNode) {
        if (this.resolverOverride != null) {
            return this.resolverOverride;
        }
        return rootNode.getConfig().getFormatSettings().getVariableResolver();
    }

    public AnySource setResolver(VariableResolver resolver) {
        this.resolverOverride = resolver;
        return this;
    }

    @Override
    public void override(ConfijNode rootNode) {
        String actualPath = this.getResolver(rootNode).resolveValue(rootNode, this.pathTemplate);
        URI path = URI.create(actualPath);
        this.sourceBuilders.stream().map(sb -> sb.fromURI(path)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> {
            String addon = this.pathTemplate.equals(actualPath) ? "" : " (resolved from '" + this.pathTemplate + "')";
            return new ConfijSourceException("failed to load source data from '{}'{}", path, addon);
        }).override(rootNode);
    }

    public String toString() {
        return "AnySource(sourceBuilders=" + this.sourceBuilders + ", pathTemplate=" + this.pathTemplate + ", resolverOverride=" + this.resolverOverride + ")";
    }
}

