/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline.reload;

import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.pipeline.reload.ConfijReloader;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimedBlockingReloader<T>
implements ConfijReloader<T> {
    private final Duration pauseAfterSuccess;
    private final Duration pauseAfterFailure;
    private final Lock reloadLock = new ReentrantLock();
    private Instant nextReloadAt = Instant.MIN;
    private ConfijPipeline<T> pipeline;
    private T current;

    public TimedBlockingReloader() {
        this(Duration.ofSeconds(30L), Duration.ofSeconds(30L));
    }

    public TimedBlockingReloader(Duration pauseAfterSuccess, Duration pauseAfterFailure) {
        this.pauseAfterSuccess = pauseAfterSuccess;
        this.pauseAfterFailure = pauseAfterFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ConfijPipeline<T> pipeline) {
        TimedBlockingReloader timedBlockingReloader = this;
        synchronized (timedBlockingReloader) {
            if (this.pipeline != null) {
                throw new IllegalStateException("already initialized");
            }
            this.pipeline = Objects.requireNonNull(pipeline);
        }
        this.doReload();
    }

    protected boolean shouldReload() {
        return this.nextReloadAt.isBefore(Instant.now());
    }

    protected void success() {
        this.nextReloadAt = Instant.now().plus(this.pauseAfterSuccess);
    }

    protected void failure() {
        this.nextReloadAt = Instant.now().plus(this.pauseAfterFailure);
    }

    public T getUpdated() {
        this.reloadLock.lock();
        try {
            T t = this.doReload();
            return t;
        }
        finally {
            this.reloadLock.unlock();
        }
    }

    @Override
    public T get() {
        if (!this.shouldReload()) {
            return this.current;
        }
        if (this.reloadLock.tryLock()) {
            try {
                if (!this.shouldReload()) {
                    T t = this.current;
                    return t;
                }
                T t = this.doReload();
                return t;
            }
            finally {
                this.reloadLock.unlock();
            }
        }
        return this.current;
    }

    protected T doReload() {
        try {
            T current = this.pipeline.build();
            this.current = current;
            this.success();
            return current;
        }
        catch (Exception e) {
            this.failure();
            throw e;
        }
    }

    public String toString() {
        return "TimedBlockingReloader(pauseAfterSuccess=" + this.pauseAfterSuccess + ", pauseAfterFailure=" + this.pauseAfterFailure + ", reloadLock=" + this.reloadLock + ", nextReloadAt=" + this.nextReloadAt + ", pipeline=" + this.pipeline + ", current=" + this.current + ")";
    }
}

