/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline.reload;

import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.pipeline.reload.ConfijReloader;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ScheduledReloader<T>
implements ConfijReloader<T> {
    private final Duration reloadEvery;
    private final Duration initialDelay;
    private final ScheduledExecutorService executor;
    private boolean isInitialized = false;
    private T current;

    public ScheduledReloader() {
        this(Duration.ofSeconds(30L));
    }

    public ScheduledReloader(Duration reloadEvery) {
        this(reloadEvery, Duration.ofSeconds(60L));
    }

    public ScheduledReloader(Duration reloadEvery, Duration initialDelay) {
        this.reloadEvery = reloadEvery;
        this.initialDelay = initialDelay;
        this.executor = Executors.newScheduledThreadPool(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ConfijPipeline<T> pipeline) {
        ScheduledReloader scheduledReloader = this;
        synchronized (scheduledReloader) {
            if (this.isInitialized) {
                throw new IllegalStateException("already initialized");
            }
            this.isInitialized = true;
        }
        this.current = pipeline.build();
        this.executor.scheduleWithFixedDelay(() -> {
            Thread.currentThread().setName("ConfijReload");
            this.current = pipeline.build();
        }, this.initialDelay.toMillis(), this.reloadEvery.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T get() {
        return this.current;
    }

    public String toString() {
        return "ScheduledReloader(reloadEvery=" + this.reloadEvery + ", initialDelay=" + this.initialDelay + ", executor=" + this.executor + ", isInitialized=" + this.isInitialized + ", current=" + this.current + ")";
    }
}

