/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline;

import ch.kk7.confij.binding.BindingContext;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import ch.kk7.confij.format.ConfigFormat;
import ch.kk7.confij.format.FormatSettings;
import ch.kk7.confij.format.resolve.NoopResolver;
import ch.kk7.confij.format.resolve.VariableResolver;
import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.pipeline.ConfijPipelineImpl;
import ch.kk7.confij.pipeline.reload.ConfijReloader;
import ch.kk7.confij.pipeline.reload.ScheduledReloader;
import ch.kk7.confij.source.AnySource;
import ch.kk7.confij.source.ConfigSource;
import ch.kk7.confij.source.defaults.DefaultSource;
import ch.kk7.confij.validation.ConfijValidator;
import ch.kk7.confij.validation.ServiceLoaderValidator;
import com.fasterxml.classmate.GenericType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public class ConfijBuilder<T> {
    private final Type forType;
    private final List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private ConfijValidator validator = null;
    private FormatSettings formatSettings = FormatSettings.newDefaultSettings();
    private BindingContext bindingContext = null;
    private ConfijReloader<T> reloader = null;

    protected ConfijBuilder(@NonNull Type forType) {
        if (forType == null) {
            throw new NullPointerException("forType is marked @NonNull but is null");
        }
        this.forType = forType;
    }

    public static <X> ConfijBuilder<X> of(Class<X> forClass) {
        return new ConfijBuilder(forClass);
    }

    public static <X> ConfijBuilder<X> of(GenericType<X> forType) {
        return new ConfijBuilder((Type)forType);
    }

    public ConfijBuilder<T> withSource(String ... sourceStr) {
        Stream.of(sourceStr).map(AnySource::new).forEachOrdered(this.sources::add);
        return this;
    }

    public ConfijBuilder<T> withSource(ConfigSource ... source) {
        this.sources.addAll(Arrays.asList(source));
        return this;
    }

    public ConfijBuilder<T> withValidator(@NonNull ConfijValidator validator) {
        if (validator == null) {
            throw new NullPointerException("validator is marked @NonNull but is null");
        }
        this.validator = validator;
        return this;
    }

    public ConfijBuilder<T> withoutValidator() {
        return this.withValidator(ConfijValidator.NOOP);
    }

    public ConfijBuilder<T> withFormatSettings(FormatSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    public ConfijBuilder<T> withTemplating(@NonNull VariableResolver variableResolver) {
        if (variableResolver == null) {
            throw new NullPointerException("variableResolver is marked @NonNull but is null");
        }
        this.formatSettings = this.formatSettings.withVariableResolver(variableResolver);
        return this;
    }

    public ConfijBuilder<T> withoutTemplating() {
        return this.withTemplating(new NoopResolver());
    }

    @NonNull
    protected BindingContext getBindingContext() {
        if (this.bindingContext == null) {
            this.bindingContext = BindingContext.newDefaultContext();
        }
        return this.bindingContext;
    }

    public ConfijBuilder<T> bindingContext(BindingContext bindingContext) {
        if (this.bindingContext != null) {
            throw new IllegalStateException("unsafe usage of BindingSettings after it has been modified already");
        }
        this.bindingContext = bindingContext;
        return this;
    }

    public ConfijBuilder<T> withValueMapperFactory(ValueMapperFactory valueMapperFactory) {
        this.bindingContext = this.getBindingContext().withMapperFactory(valueMapperFactory);
        return this;
    }

    public <I> ConfijBuilder<T> withValueMapperForClass(ValueMapperInstance<I> valueMapper, Class<I> forClass) {
        return this.withValueMapperFactory(ValueMapperFactory.forClass(valueMapper, forClass));
    }

    public ConfijBuilder<T> withReloader(@NonNull ConfijReloader<T> reloader) {
        if (reloader == null) {
            throw new NullPointerException("reloader is marked @NonNull but is null");
        }
        this.reloader = reloader;
        return this;
    }

    protected ConfijPipeline<T> buildPipeline() {
        this.validator = Optional.ofNullable(this.validator).orElseGet(ServiceLoaderValidator::new);
        ConfigBinder configBinder = new ConfigBinder();
        ConfigBinding<?> configBinding = configBinder.toRootConfigBinding(this.forType, this.getBindingContext());
        ConfigFormat configFormat = configBinding.describe(this.formatSettings);
        return new ConfijPipelineImpl(this.sources, new DefaultSource(), this.validator, configBinding, configFormat);
    }

    public T build() {
        return this.buildPipeline().build();
    }

    public ConfijReloader<T> buildReloadable() {
        this.reloader = Optional.ofNullable(this.reloader).orElseGet(ScheduledReloader::new);
        this.reloader.initialize(this.buildPipeline());
        return this.reloader;
    }
}

