/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.format;

import ch.kk7.confij.annotation.Default;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.common.ClassToImplCache;
import ch.kk7.confij.format.resolve.DefaultResolver;
import ch.kk7.confij.format.resolve.VariableResolver;
import java.lang.reflect.AnnotatedElement;
import lombok.NonNull;

public class FormatSettings {
    private final String defaultValue;
    @NonNull
    private final VariableResolver variableResolver;
    @NonNull
    private final ClassToImplCache implCache;

    public static FormatSettings newDefaultSettings() {
        ClassToImplCache implCache = new ClassToImplCache();
        return new FormatSettings(null, implCache.getInstance(DefaultResolver.class), implCache);
    }

    protected FormatSettings withVariableResolverFor(AnnotatedElement element) {
        return this.withVariableResolver(AnnotationUtil.findAnnotation(element, ch.kk7.confij.annotation.VariableResolver.class).map(ch.kk7.confij.annotation.VariableResolver::value).map(x -> this.implCache.getInstance(x, VariableResolver.class)).orElse(this.variableResolver));
    }

    protected FormatSettings withDefaultValueFor(AnnotatedElement element) {
        return this.withDefaultValue(AnnotationUtil.findAnnotation(element, Default.class).map(Default::value).orElse(this.defaultValue));
    }

    public FormatSettings settingsFor(AnnotatedElement element) {
        return this.withDefaultValueFor(element).withVariableResolverFor(element);
    }

    public String toString() {
        return "FormatSettings(defaultValue=" + this.getDefaultValue() + ", variableResolver=" + this.getVariableResolver() + ", implCache=" + this.implCache + ")";
    }

    public FormatSettings(String defaultValue, @NonNull VariableResolver variableResolver, @NonNull ClassToImplCache implCache) {
        if (variableResolver == null) {
            throw new NullPointerException("variableResolver is marked @NonNull but is null");
        }
        if (implCache == null) {
            throw new NullPointerException("implCache is marked @NonNull but is null");
        }
        this.defaultValue = defaultValue;
        this.variableResolver = variableResolver;
        this.implCache = implCache;
    }

    public FormatSettings withDefaultValue(String defaultValue) {
        return this.defaultValue == defaultValue ? this : new FormatSettings(defaultValue, this.variableResolver, this.implCache);
    }

    public FormatSettings withVariableResolver(@NonNull VariableResolver variableResolver) {
        if (variableResolver == null) {
            throw new NullPointerException("variableResolver is marked @NonNull but is null");
        }
        return this.variableResolver == variableResolver ? this : new FormatSettings(this.defaultValue, variableResolver, this.implCache);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @NonNull
    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }
}

