/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.format;

import ch.kk7.confij.format.FormatException;
import ch.kk7.confij.format.FormatSettings;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;

public abstract class ConfigFormat {
    @NonNull
    private final FormatSettings formatSettings;

    public boolean isValueHolder() {
        return false;
    }

    @NonNull
    public abstract ConfigFormat formatForChild(String var1);

    @NonNull
    public Set<String> getMandatoryKeys() {
        return Collections.emptySet();
    }

    public ConfigFormat(@NonNull FormatSettings formatSettings) {
        if (formatSettings == null) {
            throw new NullPointerException("formatSettings is marked @NonNull but is null");
        }
        this.formatSettings = formatSettings;
    }

    @NonNull
    public FormatSettings getFormatSettings() {
        return this.formatSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigFormat)) {
            return false;
        }
        ConfigFormat other = (ConfigFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FormatSettings this$formatSettings = this.getFormatSettings();
        FormatSettings other$formatSettings = other.getFormatSettings();
        return !(this$formatSettings == null ? other$formatSettings != null : !this$formatSettings.equals(other$formatSettings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FormatSettings $formatSettings = this.getFormatSettings();
        result = result * 59 + ($formatSettings == null ? 43 : $formatSettings.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigFormat(formatSettings=" + this.getFormatSettings() + ")";
    }

    public static class ConfigFormatMap
    extends ConfigFormat {
        private final ConfigFormat anyChild;
        private final Map<String, ConfigFormat> children;

        private ConfigFormatMap(FormatSettings formatSettings, ConfigFormat anyChild, Map<String, ConfigFormat> children) {
            super(formatSettings);
            this.anyChild = anyChild;
            if (children.containsValue(null)) {
                throw new IllegalArgumentException("invalid null value in " + children);
            }
            this.children = Collections.unmodifiableMap(children);
        }

        public static ConfigFormatMap fixedKeysMap(FormatSettings formatSettings, Map<String, ConfigFormat> children) {
            return new ConfigFormatMap(formatSettings, null, children);
        }

        public static ConfigFormatMap anyKeyMap(FormatSettings formatSettings, ConfigFormat anyChild) {
            return new ConfigFormatMap(formatSettings, Objects.requireNonNull(anyChild), Collections.emptyMap());
        }

        @Override
        @NonNull
        public ConfigFormat formatForChild(String configKey) {
            if (this.children.containsKey(configKey)) {
                return this.children.get(configKey);
            }
            if (this.anyChild != null) {
                return this.anyChild;
            }
            throw new FormatException("map-like format doesn't allow key '{}', allowed are: {}", configKey, this.children.keySet());
        }

        @Override
        @NonNull
        public Set<String> getMandatoryKeys() {
            return this.children.keySet();
        }

        @Override
        public String toString() {
            return "ConfigFormat.ConfigFormatMap(anyChild=" + this.anyChild + ", children=" + this.children + ")";
        }
    }

    public static class ConfigFormatList
    extends ConfigFormat {
        private final ConfigFormat anyChild;

        public ConfigFormatList(FormatSettings formatSettings, ConfigFormat anyChild) {
            super(formatSettings);
            this.anyChild = Objects.requireNonNull(anyChild);
        }

        @Override
        @NonNull
        public ConfigFormat formatForChild(String configKey) {
            int index;
            try {
                index = Integer.parseInt(configKey);
            }
            catch (NumberFormatException e) {
                throw new FormatException("invalid config key, expected a number, but found {}", configKey, e);
            }
            if (index < 0) {
                throw new FormatException("invalid config key, expected a stictly positive number, but found {}", index);
            }
            return this.anyChild;
        }

        @Override
        public String toString() {
            return "ConfigFormat.ConfigFormatList(anyChild=" + this.anyChild + ")";
        }
    }

    public static class ConfigFormatLeaf
    extends ConfigFormat {
        public ConfigFormatLeaf(FormatSettings formatSettings) {
            super(formatSettings);
        }

        @Override
        @NonNull
        public ConfigFormat formatForChild(String configKey) {
            throw new FormatException("a leaf isn't allowed to have children, not even for '{}'", configKey);
        }

        @Override
        public boolean isValueHolder() {
            return true;
        }

        @Override
        public String toString() {
            return "ConfigFormat.ConfigFormatLeaf()";
        }
    }
}

