/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.common;

import ch.kk7.confij.common.ServiceLoaderPriority;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ServiceLoaderUtil {
    private static Map<Class<?>, List<?>> serviceInstances = new ConcurrentHashMap();

    public static <T> List<T> instancesOf(Class<T> serviceClass) {
        List<?> oldResult;
        List<Object> result = serviceInstances.get(serviceClass);
        if (result == null && (oldResult = serviceInstances.putIfAbsent(serviceClass, result = ServiceLoaderUtil.newOf(serviceClass))) != null) {
            return oldResult;
        }
        return result;
    }

    public static <T> List<T> newOf(Class<T> serviceClass) {
        List<T> services = ServiceLoaderUtil.maybeNewOf(serviceClass);
        if (services.isEmpty()) {
            throw new IllegalStateException("Failed to load any instance of " + serviceClass + ". Check your AnnotationProcessor.");
        }
        return services;
    }

    public static <T> List<T> maybeNewOf(Class<T> serviceClass) {
        ServiceLoader<T> resourceFormatLoader = ServiceLoader.load(serviceClass);
        return Collections.unmodifiableList(StreamSupport.stream(resourceFormatLoader.spliterator(), false).sorted(Comparator.comparing(o -> o.getClass().getName())).sorted(Comparator.comparing(ServiceLoaderPriority::priorityOf).reversed()).collect(Collectors.toList()));
    }

    private ServiceLoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

