/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.BindingException;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.AbstractClassValueMapper;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DurationMapper
extends AbstractClassValueMapper<Duration> {
    public DurationMapper() {
        super(Duration.class);
    }

    @Override
    public ValueMapperInstance<Duration> newInstance(BindingType bindingType) {
        return new DurationMapperInstance();
    }

    public static class DurationMapperInstance
    implements ValueMapperInstance.NullableValueMapperInstance<Duration> {
        private static long parseDurationAsNanos(String s) {
            String unitString = DurationMapperInstance.getUnits(s);
            String numberString = s.substring(0, s.length() - unitString.length()).trim();
            if (numberString.length() == 0) {
                throw new BindingException("bad value: cannot convert an empty value to a Duration");
            }
            TimeUnit units = DurationMapperInstance.stringToTimeUnit(unitString);
            try {
                if (numberString.matches("[+-]?[0-9]+")) {
                    return units.toNanos(Long.parseLong(numberString));
                }
                long nanosInUnit = units.toNanos(1L);
                return (long)(Double.parseDouble(numberString) * (double)nanosInUnit);
            }
            catch (NumberFormatException e) {
                throw new BindingException("Could not parse duration number '{}'", numberString);
            }
        }

        private static TimeUnit stringToTimeUnit(String unitString) {
            if (unitString.length() > 2 && !unitString.endsWith("s")) {
                unitString = unitString + "s";
            }
            switch (unitString) {
                case "": 
                case "ms": 
                case "millis": 
                case "milliseconds": {
                    return TimeUnit.MILLISECONDS;
                }
                case "us": 
                case "micros": 
                case "microseconds": {
                    return TimeUnit.MICROSECONDS;
                }
                case "ns": 
                case "nanos": 
                case "nanoseconds": {
                    return TimeUnit.NANOSECONDS;
                }
                case "d": 
                case "days": {
                    return TimeUnit.DAYS;
                }
                case "h": 
                case "hours": {
                    return TimeUnit.HOURS;
                }
                case "s": 
                case "seconds": {
                    return TimeUnit.SECONDS;
                }
                case "m": 
                case "minutes": {
                    return TimeUnit.MINUTES;
                }
            }
            throw new BindingException("Could not parse time unit '{}' (try ns, us, ms, s, m, h, d)", unitString);
        }

        public static String getUnits(String s) {
            char c;
            int i;
            for (i = s.length() - 1; i >= 0 && Character.isLetter(c = s.charAt(i)); --i) {
            }
            return s.substring(i + 1);
        }

        @Override
        public Duration fromNonNullString(String string) {
            long nanos = DurationMapperInstance.parseDurationAsNanos(string);
            return Duration.ofNanos(nanos);
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ValueMapper(value=DurationMapper.class)
    public static @interface Type {
    }
}

