/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.values;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.binding.values.ValueMapperInstance;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import lombok.NonNull;

public class DateTimeMapper
implements ValueMapperFactory {
    @Override
    public Optional<ValueMapperInstance<?>> maybeForType(BindingType bindingType) {
        Class type = bindingType.getResolvedType().getErasedType();
        if (type.equals(Date.class)) {
            return Optional.of(this.newDateMapperInstance(bindingType));
        }
        if (type.equals(OffsetDateTime.class)) {
            return Optional.of(this.newOffsetDateTimeMapperInstance(bindingType));
        }
        return Optional.empty();
    }

    protected DateMapperInstance newDateMapperInstance(BindingType bindingType) {
        return new DateMapperInstance(this.newOffsetDateTimeMapperInstance(bindingType));
    }

    protected OffsetDateTimeMapperInstance newOffsetDateTimeMapperInstance(BindingType bindingType) {
        DateTime dateTime = bindingType.getBindingContext().getFactoryConfigFor(DateTimeMapper.class).filter(DateTime.class::isInstance).map(DateTime.class::cast).orElse(AnnonHolder.class.getAnnotation(DateTime.class));
        Locale formatLang = dateTime.lang().isEmpty() ? Locale.getDefault(Locale.Category.FORMAT) : Locale.forLanguageTag(dateTime.lang());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateTime.value(), formatLang);
        return new OffsetDateTimeMapperInstance(dateTimeFormatter);
    }

    public static class DateMapperInstance
    implements ValueMapperInstance<Date> {
        @NonNull
        private final OffsetDateTimeMapperInstance mapperInstance;

        @Override
        public Date fromString(String string) {
            return Date.from(this.mapperInstance.fromString(string).toInstant());
        }

        public DateMapperInstance(@NonNull OffsetDateTimeMapperInstance mapperInstance) {
            if (mapperInstance == null) {
                throw new NullPointerException("mapperInstance is marked @NonNull but is null");
            }
            this.mapperInstance = mapperInstance;
        }
    }

    public static class OffsetDateTimeMapperInstance
    implements ValueMapperInstance<OffsetDateTime> {
        @NonNull
        private final DateTimeFormatter dateTimeFormatter;

        @Override
        public OffsetDateTime fromString(String string) {
            return OffsetDateTime.parse(string, this.dateTimeFormatter);
        }

        public OffsetDateTimeMapperInstance(@NonNull DateTimeFormatter dateTimeFormatter) {
            if (dateTimeFormatter == null) {
                throw new NullPointerException("dateTimeFormatter is marked @NonNull but is null");
            }
            this.dateTimeFormatter = dateTimeFormatter;
        }
    }

    @DateTime
    private static final class AnnonHolder {
        private AnnonHolder() {
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ValueMapper(value=DateTimeMapper.class)
    public static @interface DateTime {
        public String value() default "yyyy-MM-dd'T'HH:mm:ss.SXXX";

        public String lang() default "";
    }
}

