/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.map;

import ch.kk7.confij.binding.BindingException;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.RawConstructor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class MapBuilder {
    private final Supplier<Map> supplier;
    private final Function<Map, Map> hardener;

    public MapBuilder(ResolvedType type) {
        if (!type.isInstanceOf(Map.class)) {
            throw new IllegalArgumentException("expected a map type, but got " + type);
        }
        this.supplier = this.newMapSupplier(type);
        this.hardener = this.newMapHardener(type);
    }

    protected Supplier<Map> newMapSupplier(ResolvedType type) {
        if (type.isInterface()) {
            return this.interfaceSupplier(type);
        }
        return this.constructorSupplier(type);
    }

    protected Supplier<Map> interfaceSupplier(ResolvedType type) {
        Class intfClass = type.getErasedType();
        if (intfClass.isAssignableFrom(HashMap.class)) {
            return HashMap::new;
        }
        if (intfClass.isAssignableFrom(TreeMap.class)) {
            return TreeMap::new;
        }
        throw new BindingException("Attempting to bind to a Map of interface-type {}. However no supported implementation is known for this. Prefer Map directly.", type);
    }

    protected Supplier<Map> constructorSupplier(ResolvedType type) {
        Constructor constructor = type.getConstructors().stream().map(RawConstructor::getRawMember).filter(c -> c.getParameterCount() == 0).findAny().orElseThrow(() -> new BindingException("Attempted to bind to a Map of type {}. However this class doesn't provide a no-arg constructor. It's preferable to use a tree Map interface instead of concrete Map classes.", type));
        return () -> {
            try {
                return (Map)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new BindingException("unable to call no-arg constructor on {}", type, e);
            }
        };
    }

    protected Function<Map, Map> newMapHardener(ResolvedType type) {
        Class intfClass = type.getErasedType();
        if (Map.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableMap(x);
        }
        if (SortedMap.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableSortedMap((SortedMap)x);
        }
        if (NavigableMap.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableNavigableMap((NavigableMap)x);
        }
        return x -> x;
    }

    public <K, V> Map<K, V> newInstance() {
        return this.supplier.get();
    }

    public <K, V> Map<K, V> tryHarden(Map<K, V> collection) {
        return this.hardener.apply(collection);
    }
}

