/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBindingFactory;
import ch.kk7.confij.binding.intf.InterfaceBinding;
import ch.kk7.confij.common.ConfijException;
import com.fasterxml.classmate.ResolvedType;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;

public class InterfaceBindingFactory
implements ConfigBindingFactory<InterfaceBinding> {
    private Stack<ResolvedType> callStack = new Stack();

    private String stackAsString() {
        return this.callStack.stream().map(ResolvedType::getBriefDescription).collect(Collectors.joining("\u2192"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<InterfaceBinding> maybeCreate(BindingType bindingType, ConfigBinder configBinder) {
        ResolvedType type = bindingType.getResolvedType();
        if (type.isInterface()) {
            if (this.callStack.contains(type)) {
                throw new ConfijException("circular interface definition: {}: cannot add another {}", this.stackAsString(), type);
            }
            this.callStack.push(type);
            try {
                Optional<InterfaceBinding> optional = Optional.of(new InterfaceBinding(bindingType, configBinder));
                return optional;
            }
            finally {
                this.callStack.pop();
            }
        }
        return Optional.empty();
    }
}

