/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.annotation.Key;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.intf.InterfaceProxyBuilder;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.format.ConfigFormat;
import ch.kk7.confij.format.FormatSettings;
import ch.kk7.confij.source.tree.ConfijNode;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.types.ResolvedInterfaceType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class InterfaceBinding<T>
implements ConfigBinding<T> {
    private final Map<String, AttributeInformation> siblingsByName;
    private final InterfaceProxyBuilder<T> interfaceBuilder;

    public InterfaceBinding(BindingType bindingType, ConfigBinder configBinder) {
        ResolvedType baseType = bindingType.getResolvedType();
        if (!(baseType instanceof ResolvedInterfaceType)) {
            throw new IllegalArgumentException("expected type " + baseType + " to be a " + ResolvedInterfaceType.class);
        }
        this.siblingsByName = new LinkedHashMap<String, AttributeInformation>();
        this.interfaceBuilder = new InterfaceProxyBuilder((ResolvedInterfaceType)baseType);
        for (ResolvedMethod method : this.interfaceBuilder.getAllowedMethods()) {
            BindingType methodBindingType = bindingType.bindingFor(method.getReturnType(), bindingType.getBindingContext().settingsFor((AnnotatedElement)((Object)method.getRawMember())));
            ConfigBinding<?> methodDescription = configBinder.toConfigBinding(methodBindingType);
            String configKey = AnnotationUtil.findAnnotation((AnnotatedElement)((Object)method.getRawMember()), Key.class).map(Key::value).orElse(method.getName());
            this.siblingsByName.put(configKey, new AttributeInformation(methodDescription, method));
        }
    }

    @Override
    public ConfigFormat.ConfigFormatMap describe(FormatSettings formatSettings) {
        FormatSettings settingsForThisClass = formatSettings.settingsFor(this.interfaceBuilder.getType().getErasedType());
        return ConfigFormat.ConfigFormatMap.fixedKeysMap(settingsForThisClass, this.siblingsByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AttributeInformation)e.getValue()).getDescription().describe(settingsForThisClass.settingsFor((AnnotatedElement)((Object)((AttributeInformation)e.getValue()).getMethod().getRawMember()))))));
    }

    @Override
    public T bind(ConfijNode config) {
        Map<String, ConfijNode> childConfigs = config.getChildren();
        InterfaceProxyBuilder.ValidatingProxyBuilder builder = this.interfaceBuilder.builder();
        this.siblingsByName.forEach((key, siblingDescription) -> {
            Object siblingValue = siblingDescription.getDescription().bind((ConfijNode)childConfigs.get(key));
            ResolvedMethod method = siblingDescription.getMethod();
            if (((Method)method.getRawMember()).isDefault() && this.isEmpty(siblingValue)) {
                return;
            }
            builder.methodToValue(method, siblingValue);
        });
        return builder.build();
    }

    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    public String toString() {
        return "InterfaceBinding(siblingsByName=" + this.siblingsByName + ", interfaceBuilder=" + this.interfaceBuilder + ")";
    }

    public static class AttributeInformation {
        private final ConfigBinding<?> description;
        private final ResolvedMethod method;

        public AttributeInformation(ConfigBinding<?> description, ResolvedMethod method) {
            this.description = description;
            this.method = method;
        }

        public ConfigBinding<?> getDescription() {
            return this.description;
        }

        public ResolvedMethod getMethod() {
            return this.method;
        }
    }
}

