/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.collection;

import ch.kk7.confij.binding.BindingException;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.RawConstructor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;

public class CollectionBuilder {
    private final Supplier<Collection> supplier;
    private final Function<Collection, Collection> hardener;

    public CollectionBuilder(ResolvedType type) {
        if (!type.isInstanceOf(Collection.class)) {
            throw new IllegalArgumentException("expected a collection type, but got " + type);
        }
        this.supplier = this.newCollectionSupplier(type);
        this.hardener = this.newCollectionHardener(type);
    }

    protected Function<Collection, Collection> newCollectionHardener(ResolvedType type) {
        Class intfClass = type.getErasedType();
        if (Set.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableSet((Set)x);
        }
        if (List.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableList((List)x);
        }
        if (SortedSet.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableSortedSet((SortedSet)x);
        }
        if (NavigableSet.class.equals((Object)intfClass)) {
            return x -> Collections.unmodifiableNavigableSet((NavigableSet)x);
        }
        return x -> x;
    }

    protected Supplier<Collection> newCollectionSupplier(ResolvedType type) {
        if (type.isInterface()) {
            return this.interfaceSupplier(type);
        }
        return this.constructorSupplier(type);
    }

    protected Supplier<Collection> interfaceSupplier(ResolvedType type) {
        Class intfClass = type.getErasedType();
        if (intfClass.isAssignableFrom(LinkedHashSet.class)) {
            return LinkedHashSet::new;
        }
        if (intfClass.isAssignableFrom(ArrayList.class)) {
            return ArrayList::new;
        }
        if (intfClass.isAssignableFrom(TreeSet.class)) {
            return TreeSet::new;
        }
        throw new BindingException("Attempting to bind to a Collection of interface-type {}. However no supported implementation is known for this. Prefer Set or List directly.", type);
    }

    protected Supplier<Collection> constructorSupplier(ResolvedType type) {
        Constructor constructor = type.getConstructors().stream().map(RawConstructor::getRawMember).filter(c -> c.getParameterCount() == 0).findAny().orElseThrow(() -> new BindingException("Attempted to bind to a Collection of type {}. However this class doesn't provide a no-arg constructor. It's preferable to use tree Set or List interfaces instead of concrete Collection classes.", type));
        return () -> {
            try {
                return (Collection)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new BindingException("unable to call no-arg constructor on {}", type, e);
            }
        };
    }

    public <T> Collection<T> newInstance() {
        return this.supplier.get();
    }

    public <T> Collection<T> tryHarden(Collection<T> collection) {
        return this.hardener.apply(collection);
    }
}

