/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.collection;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.collection.CollectionBuilder;
import ch.kk7.confij.binding.collection.CollectionUtil;
import ch.kk7.confij.format.ConfigFormat;
import ch.kk7.confij.format.FormatSettings;
import ch.kk7.confij.source.tree.ConfijNode;
import java.util.Collection;
import java.util.List;

public class CollectionBinding<T>
implements ConfigBinding<Collection<T>> {
    private final CollectionBuilder builder;
    private final ConfigBinding<T> componentDescription;

    public CollectionBinding(CollectionBuilder builder, BindingType componentBindingType, ConfigBinder configBinder) {
        this.builder = builder;
        this.componentDescription = configBinder.toConfigBinding(componentBindingType);
    }

    @Override
    public ConfigFormat.ConfigFormatList describe(FormatSettings formatSettings) {
        return new ConfigFormat.ConfigFormatList(formatSettings, this.componentDescription.describe(formatSettings));
    }

    @Override
    public Collection<T> bind(ConfijNode config) {
        List<ConfijNode> childNodes = CollectionUtil.childrenAsContinuousList(config);
        Collection collection = this.builder.newInstance();
        for (ConfijNode childNode : childNodes) {
            T listItem = this.componentDescription.bind(childNode);
            collection.add(listItem);
        }
        return this.builder.tryHarden(collection);
    }
}

