/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.array;

import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinder;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.collection.CollectionUtil;
import ch.kk7.confij.format.ConfigFormat;
import ch.kk7.confij.format.FormatSettings;
import ch.kk7.confij.source.tree.ConfijNode;
import com.fasterxml.classmate.ResolvedType;
import java.lang.reflect.Array;
import java.util.List;

public class ArrayBinding<T>
implements ConfigBinding<Object> {
    private final ResolvedType componentType;
    private final ConfigBinding<T> componentDescription;

    public ArrayBinding(BindingType bindingType, ConfigBinder configBinder) {
        this.componentType = bindingType.getResolvedType();
        this.componentDescription = configBinder.toConfigBinding(bindingType);
    }

    @Override
    public ConfigFormat.ConfigFormatList describe(FormatSettings formatSettings) {
        return new ConfigFormat.ConfigFormatList(formatSettings, this.componentDescription.describe(formatSettings));
    }

    @Override
    public Object bind(ConfijNode config) {
        List<ConfijNode> childNodes = CollectionUtil.childrenAsContinuousList(config);
        Object result = Array.newInstance(this.componentType.getErasedType(), childNodes.size());
        int i = 0;
        for (ConfijNode childNode : childNodes) {
            Array.set(result, i++, this.componentDescription.bind(childNode));
        }
        return result;
    }
}

