/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding;

import ch.kk7.confij.annotation.ValueMapper;
import ch.kk7.confij.binding.values.DateTimeMapper;
import ch.kk7.confij.binding.values.DurationMapper;
import ch.kk7.confij.binding.values.EnumMapper;
import ch.kk7.confij.binding.values.ExplicitMapper;
import ch.kk7.confij.binding.values.PeriodMapper;
import ch.kk7.confij.binding.values.PrimitiveMapperFactory;
import ch.kk7.confij.binding.values.SoloConstructorMapper;
import ch.kk7.confij.binding.values.StaticFunctionMapper;
import ch.kk7.confij.binding.values.ValueMapperFactory;
import ch.kk7.confij.common.AnnotationUtil;
import ch.kk7.confij.common.ClassToImplCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class BindingContext {
    private final ValueMapperFactory forcedMapperFactory;
    @NonNull
    private final List<ValueMapperFactory> mapperFactories;
    @NonNull
    private final Map<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs;
    @NonNull
    private final ClassToImplCache implCache;

    public BindingContext(ValueMapperFactory forcedMapperFactory, @NonNull List<ValueMapperFactory> mapperFactories, @NonNull Map<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs, @NonNull ClassToImplCache implCache) {
        if (mapperFactories == null) {
            throw new NullPointerException("mapperFactories is marked @NonNull but is null");
        }
        if (factoryConfigs == null) {
            throw new NullPointerException("factoryConfigs is marked @NonNull but is null");
        }
        if (implCache == null) {
            throw new NullPointerException("implCache is marked @NonNull but is null");
        }
        this.forcedMapperFactory = forcedMapperFactory;
        this.mapperFactories = Collections.unmodifiableList(mapperFactories);
        this.factoryConfigs = Collections.unmodifiableMap(factoryConfigs);
        this.implCache = implCache;
    }

    public static BindingContext newDefaultContext() {
        List<ValueMapperFactory> mapperFactories = Arrays.asList(ExplicitMapper.forString(), new PrimitiveMapperFactory(), ExplicitMapper.forFile(), ExplicitMapper.forPath(), new EnumMapper(), new DurationMapper(), new PeriodMapper(), new DateTimeMapper(), new StaticFunctionMapper(), new SoloConstructorMapper());
        return new BindingContext(null, mapperFactories, Collections.emptyMap(), new ClassToImplCache());
    }

    public Optional<ValueMapperFactory> getForcedMapperFactory() {
        return Optional.ofNullable(this.forcedMapperFactory);
    }

    public BindingContext withMapperFactory(ValueMapperFactory valueMapperFactory) {
        ArrayList<ValueMapperFactory> factories = new ArrayList<ValueMapperFactory>();
        factories.add(valueMapperFactory);
        factories.addAll(this.mapperFactories);
        return this.withMapperFactories(factories);
    }

    protected BindingContext withMapperFactoryFor(ValueMapper valueMapper) {
        Class<? extends ValueMapperFactory> clazz = valueMapper.value();
        ValueMapperFactory mapperFactory = this.implCache.getInstance(clazz, ValueMapperFactory.class);
        if (valueMapper.force()) {
            return this.withForcedMapperFactory(mapperFactory);
        }
        return this.withMapperFactory(mapperFactory);
    }

    public Optional<Annotation> getFactoryConfigFor(Class<? extends ValueMapperFactory> forClass) {
        return Optional.ofNullable(this.factoryConfigs.get(forClass));
    }

    protected BindingContext withFactoryConfigFor(Class<? extends ValueMapperFactory> forClass, Annotation declaringAnnotation) {
        HashMap<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs = new HashMap<Class<? extends ValueMapperFactory>, Annotation>(this.factoryConfigs);
        factoryConfigs.put(forClass, declaringAnnotation);
        return this.withFactoryConfigs(factoryConfigs);
    }

    public BindingContext settingsFor(AnnotatedElement element) {
        Optional<AnnotationUtil.AnnonResponse<ValueMapper>> declaration = AnnotationUtil.findAnnotationAndDeclaration(element, ValueMapper.class);
        if (declaration.isPresent()) {
            AnnotationUtil.AnnonResponse<ValueMapper> response = declaration.get();
            ValueMapper valueMapper = response.getAnnotationType();
            return this.withFactoryConfigFor(valueMapper.value(), response.getDeclaredAnnotation()).withMapperFactoryFor(valueMapper);
        }
        return this;
    }

    public BindingContext withForcedMapperFactory(ValueMapperFactory forcedMapperFactory) {
        return this.forcedMapperFactory == forcedMapperFactory ? this : new BindingContext(forcedMapperFactory, this.mapperFactories, this.factoryConfigs, this.implCache);
    }

    public BindingContext withMapperFactories(@NonNull List<ValueMapperFactory> mapperFactories) {
        if (mapperFactories == null) {
            throw new NullPointerException("mapperFactories is marked @NonNull but is null");
        }
        return this.mapperFactories == mapperFactories ? this : new BindingContext(this.forcedMapperFactory, mapperFactories, this.factoryConfigs, this.implCache);
    }

    public BindingContext withFactoryConfigs(@NonNull Map<Class<? extends ValueMapperFactory>, Annotation> factoryConfigs) {
        if (factoryConfigs == null) {
            throw new NullPointerException("factoryConfigs is marked @NonNull but is null");
        }
        return this.factoryConfigs == factoryConfigs ? this : new BindingContext(this.forcedMapperFactory, this.mapperFactories, factoryConfigs, this.implCache);
    }

    @NonNull
    public List<ValueMapperFactory> getMapperFactories() {
        return this.mapperFactories;
    }
}

