/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.GeneratedVersion;
import ch.inftec.ju.versioverride.PomVersion;
import ch.inftec.ju.versioverride.StaticVersion;
import ch.inftec.ju.versioverride.Version;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;

public enum VersionStrategy {
    EXTERNAL{

        @Override
        public Version create(Model model, String overriddenVersion, BuildServer buildServer, Logger logger) throws IOException {
            return new StaticVersion(model, overriddenVersion, buildServer, logger);
        }
    }
    ,
    POM{

        @Override
        public Version create(Model model, String overriddenVersion, BuildServer buildServer, Logger logger) throws IOException {
            return new GeneratedVersion(model, buildServer, logger);
        }
    }
    ,
    NONE{

        @Override
        public Version create(Model model, String overriddenVersion, BuildServer buildServer, Logger logger) throws IOException {
            return new PomVersion(model, logger);
        }
    };


    public static VersionStrategy determine(String value) {
        if (value != null && value.trim().length() > 0) {
            if (value.toLowerCase().equals("true")) {
                return POM;
            }
            if (value.toLowerCase().equals("false")) {
                return NONE;
            }
            return EXTERNAL;
        }
        return POM;
    }

    public abstract Version create(Model var1, String var2, BuildServer var3, Logger var4) throws IOException;
}

