/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.logging.Logger;

public class VersionClassifier {
    private final BuildServer buildServer;
    private static String branchPattern = "[A-Z]+-[0-9]+";
    private static String releasePattern = "(.*/)*(.*)(/.*)";
    private Logger logger;

    public VersionClassifier(Logger logger, BuildServer buildServer) {
        this.logger = logger;
        this.buildServer = buildServer;
    }

    public String getClassifier(String defaultClassifier) {
        ClassifierType type = ClassifierType.valueOf(System.getProperty("classifier.type", "DEVELOP"));
        this.logger.info(String.format("using classifier.type '%s', override this with setting -Dclassifier.type=RELEASE|DEVELOP|PERSONAL", new Object[]{type}));
        if (type == ClassifierType.PERSONAL) {
            String issueIdentifier = this.getIssueIdentifierFromBranch(this.buildServer.getBranchName());
            String jobName = this.buildServer.getJobName();
            if (issueIdentifier != null) {
                this.logger.info(String.format("found an issue id in branch name, personal classifier is: %s", issueIdentifier));
                return String.format("%s_%s", jobName, issueIdentifier);
            }
            this.logger.info(String.format("no issue id found in branch name, personal classifier is: %s", issueIdentifier));
            this.logger.info(String.format("additional info: naming pattern of your branch for having an issue id must be something like this 'feature/ABC-765_some-fancy-branch-name'", new Object[0]));
            return String.format("%s", jobName);
        }
        if (type == ClassifierType.DEVELOP) {
            String issueIdentifier = this.getIssueIdentifierFromBranch(this.buildServer.getBranchName());
            if (issueIdentifier != null) {
                this.logger.info(String.format("found an issue id in branch name, classifier is: %s", issueIdentifier));
                return String.format("%s", issueIdentifier);
            }
            this.logger.info(String.format("no issue id found in branch name, classifier is: %s", defaultClassifier));
            this.logger.info(String.format("additional info: naming pattern of your branch for having an issue id must be something like this 'feature/ABC-765_some-fancy-branch-name'", new Object[0]));
        } else if (type == ClassifierType.RELEASE) {
            String classifier = this.getReleaseIdentifierFromBranch(this.buildServer.getBranchName());
            if (classifier != null) {
                return classifier;
            }
            this.logger.warn(String.format("despite classifier.type is set to '%s' no branch label has been found (e.g. origin/beta/PR-11_myfeaturebranch)", new Object[]{type}));
        }
        if (defaultClassifier.equals("SNAPSHOT")) {
            defaultClassifier = "S";
        }
        this.logger.info(String.format("using classifier '%s' from pom.xml as is (except 'SNAPSHOT' which gets shorten to 'S')", defaultClassifier));
        return defaultClassifier;
    }

    public String getIssueIdentifierFromBranch(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(branchPattern);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return input.substring(matcher.start(), matcher.end()).replaceAll("-", "");
        }
        return null;
    }

    public String getReleaseIdentifierFromBranch(String input) {
        this.logger.info(String.format("try to find classifier from branch '%s'", input));
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(releasePattern);
        Matcher matcher = pattern.matcher(input);
        if (matcher.matches()) {
            String classifier = matcher.group(2);
            this.logger.info(String.format("found classifier '%s' based on branch %s", classifier, input));
            return classifier;
        }
        return null;
    }

    static enum ClassifierType {
        RELEASE,
        DEVELOP,
        PERSONAL;

    }
}

