/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.Version;
import ch.inftec.ju.versioverride.VersionOverrideModelReader;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;

public class StaticVersion
implements Version {
    private final String groupId;
    private final String originalVersion;
    private final String version;

    public StaticVersion(Model model, String overriddenVersion, BuildServer buildServer, Logger logger) throws IOException {
        this.groupId = VersionOverrideModelReader.getGroupId(model);
        this.originalVersion = model.getVersion();
        this.version = this.generateVersion(overriddenVersion, buildServer, logger);
        logger.info(String.format("initialize groupId to '%s', the version %s will be applied to all modules and dependencies starting with this groupdId will be changed!", this.groupId, this.version));
    }

    private String generateVersion(String overriddenVersion, BuildServer buildServer, Logger logger) {
        boolean withBuildId = Boolean.valueOf(System.getProperty("version.buildId", "true"));
        if (withBuildId) {
            String buildNumber = this.getBuildNumber(buildServer, logger);
            logger.info("appending the buildId to the overridden version.");
            return String.format("%s-%s", overriddenVersion, buildNumber);
        }
        return overriddenVersion;
    }

    private String getBuildNumber(BuildServer buildServer, Logger logger) {
        try {
            return buildServer.getBuildNumber();
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return "nA";
        }
    }

    @Override
    public String getOriginalVersion() {
        return this.originalVersion;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getOverriddenVersion() {
        return this.version;
    }
}

