/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.Version;
import ch.inftec.ju.versioverride.VersionClassifier;
import ch.inftec.ju.versioverride.VersionOverrideModelReader;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;

public class GeneratedVersion
implements Version {
    private final String groupId;
    private final String originalVersion;
    private final String version;
    private final Logger logger;

    public GeneratedVersion(Model model, BuildServer buildServer, Logger logger) throws IOException {
        this.logger = logger;
        this.groupId = VersionOverrideModelReader.getGroupId(model);
        this.originalVersion = model.getVersion();
        this.version = this.generateVersion(model, buildServer);
        logger.info(String.format("initialize groupId to '%s', the version of all modules and dependencies starting with this groupdId will be changed!", this.groupId));
    }

    private String generateVersion(Model model, BuildServer buildServer) {
        String[] pomVersionTokens = model.getVersion().split("-");
        String buildId = "nA";
        try {
            buildId = buildServer.getBuildNumber();
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        if (buildServer.isOnMasterBranch()) {
            this.logger.info(String.format("branch is 'master', only append the buildId to the version in the pom, classifier is ignored", new Object[0]));
            return String.format("%s-%s", pomVersionTokens[0], buildId);
        }
        if (buildServer.isOnDevelopBranch()) {
            this.logger.info(String.format("branch is 'develop', take the snapshot version and append a buildId", new Object[0]));
            return String.format("%s-%s-%s", pomVersionTokens[0], "S", buildId);
        }
        this.logger.info(String.format("branch is %s, generate a version", buildServer.getBranchName()));
        VersionClassifier versionClassifier = new VersionClassifier(this.logger, buildServer);
        String classifier = versionClassifier.getClassifier(pomVersionTokens[1]);
        return String.format("%s-%s-%s", pomVersionTokens[0], classifier, buildId);
    }

    @Override
    public String getOriginalVersion() {
        return this.originalVersion;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getOverriddenVersion() {
        return this.version;
    }
}

