/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import ch.inftec.ju.versioverride.VersionOverrideModelReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Assert;
import org.junit.Test;

public class VersionModelReaderTest
extends AbstractVersionOverrideTest {
    @Test
    public void testValidSinglePom() {
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("valid/single/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            Assert.assertEquals((Object)"0.0.1-SNAPSHOT", (Object)model.getVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFailingSnapshotDep() {
        System.setProperty("version.override", "1.2.3");
        System.setProperty("version.override.check-snapshot-dependency", "TrUe");
        System.setProperty("version.override.fail-on-error", "TrUe");
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("valid/single/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.fail((String)"this test should fail with a illegal argument exception");
        }
        catch (IOException e) {
            if (e.getCause() instanceof MavenExecutionException) {
                Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("there is a snapshot dependency"));
            }
            Assert.fail((String)"expected MavenExecutionException");
        }
    }

    @Test
    public void testValidMultiModulePom() {
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("valid/multi/modules/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            Assert.assertEquals((Object)"0.0.1-SNAPSHOT", (Object)model.getParent().getVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testValidMultiModulePomWithOverriddenVersion() {
        System.setProperty("version.override", "1.2.3");
        System.setProperty("version.override.strict", "false");
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("valid/multi/modules/project2/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNonFailingSnapshotDep() {
        System.setProperty("version.override", "1.2.3");
        System.setProperty("version.override.check-snapshot-dependency", "TrUe");
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("valid/single/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            Assert.assertTrue((boolean)this.hasAtLeastOneSnapshotDependency(model.getDependencies()));
        }
        catch (IOException e) {
            Assert.fail((String)"no exception should occur");
        }
    }

    @Test
    public void testNoSnapshotDep() {
        System.setProperty("version.override", "1.2.3");
        System.setProperty("version.override.check-snapshot-dependency", "TrUe");
        System.setProperty("version.override.fail-on-error", "TrUe");
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("no-snapshot-dep/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsVersionOverridden() {
        System.setProperty("version.override", "");
        new VersionOverrideModelReader();
        Assert.assertTrue((boolean)VersionOverrideModelReader.isVersionOverridden());
        System.clearProperty("version.override");
        new VersionOverrideModelReader();
        Assert.assertFalse((boolean)VersionOverrideModelReader.isVersionOverridden());
    }

    private boolean hasAtLeastOneSnapshotDependency(List<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            if (!dep.getVersion().contains("SNAPSHOT")) continue;
            return true;
        }
        return false;
    }

    private Model createAndInitializeDefaultVersionModelReader() {
        InputStream correctPomFile = VersionModelReaderTest.class.getResourceAsStream("no-snapshot-dep/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            return model;
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

