/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.Version;
import ch.inftec.ju.versioverride.VersionFactory;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class ExternalStrategyTest {
    @Mock
    Model model = (Model)Mockito.mock(Model.class);
    @Mock
    BuildServer buildServer = (BuildServer)Mockito.mock(BuildServer.class);

    @Before
    public void before() {
        VersionFactory.version = null;
    }

    @Test
    public void testWithBuildIdPropertySet() {
        System.setProperty("version.buildId", "true");
        try {
            Mockito.when((Object)this.buildServer.getBuildNumber()).thenReturn((Object)"101");
            Version version = VersionFactory.create((String)"1.2.3-beta", (Model)this.model, (BuildServer)this.buildServer, (Logger)new ConsoleLogger());
            Assert.assertNotNull((Object)version);
            junit.framework.Assert.assertEquals((String)"1.2.3-beta-101", (String)version.getOverriddenVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithoutBuildId() {
        System.setProperty("version.buildId", "false");
        try {
            Mockito.when((Object)this.buildServer.getBuildNumber()).thenReturn((Object)"101");
            Version version = VersionFactory.create((String)"1.2.3-beta", (Model)this.model, (BuildServer)this.buildServer, (Logger)new ConsoleLogger());
            Assert.assertNotNull((Object)version);
            junit.framework.Assert.assertEquals((String)"1.2.3-beta", (String)version.getOverriddenVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

