/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.Version;
import ch.inftec.ju.versioverride.VersionFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.ModelReader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

@Component(role=ModelReader.class, hint="custom-version-model-reader")
public class VersionOverrideModelReader
extends DefaultModelReader
implements ModelReader {
    static final String MAVENEXT_RELEASE_VERSION = "version.override";
    static final String MAVENEXT_BE_STRICT = "version.override.strict";
    static final String MAVENEXT_CHECK_SNAPSHOT_DEP_FAIL_ON_ERROR = "version.override.fail-on-error";
    static final String MAVENEXT_CHECK_SNAPSHOT_DEP = "version.override.check-snapshot-dependency";
    static final String MAVENEXT_BUILDNUMBER_FILE = ".buildnumber";
    private static Version version = null;
    @Requirement
    private Logger logger = new ConsoleLogger();

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model model = super.read(input, options);
        String overriddenVersion = System.getProperty(MAVENEXT_RELEASE_VERSION);
        if (overriddenVersion == null) {
            return model;
        }
        String currentGroupId = VersionOverrideModelReader.getGroupId(model);
        version = VersionFactory.create(overriddenVersion, model, this.logger);
        System.setProperty(MAVENEXT_RELEASE_VERSION, version.getOverriddenVersion());
        Boolean beStrict = Boolean.parseBoolean(System.getProperty(MAVENEXT_BE_STRICT, "true"));
        if (currentGroupId.equals(version.getGroupId()) || currentGroupId.startsWith(version.getGroupId() + ".")) {
            String modelVersion = this.getVersion(model);
            if (beStrict.booleanValue() && !modelVersion.equals(version.getOriginalVersion())) {
                this.logger.info(String.format("version of %s (%s) not changed as the version is different than ${project.version}: %s", model, model.getVersion(), version.getOverriddenVersion()));
            } else {
                Parent parent;
                model.setVersion(version.getOverriddenVersion());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("changing version of %s to %s", model, version.getOverriddenVersion()));
                }
                if ((parent = model.getParent()) != null && (parent.getGroupId().equals(version.getGroupId()) || parent.getGroupId().startsWith(version.getGroupId() + "."))) {
                    this.logger.debug(String.format("changing version of parent  %s  to %s", parent, version.getOverriddenVersion()));
                    parent.setVersion(version.getOverriddenVersion());
                }
            }
        }
        Boolean checkSnapshotDependencies = Boolean.parseBoolean(System.getProperty(MAVENEXT_CHECK_SNAPSHOT_DEP));
        Boolean failOnError = Boolean.parseBoolean(System.getProperty(MAVENEXT_CHECK_SNAPSHOT_DEP_FAIL_ON_ERROR));
        if (checkSnapshotDependencies == Boolean.TRUE) {
            for (Dependency dep : model.getDependencies()) {
                String depVersion = dep.getVersion();
                if (depVersion == null || !depVersion.contains("SNAPSHOT")) continue;
                File pomFile = model.getPomFile();
                String pomFilePath = "[path not available]";
                if (pomFile != null) {
                    pomFilePath = pomFile.getPath();
                }
                String errorMsg = String.format("there is a snapshot dependency (%s) in %s (%s)", dep, model, pomFilePath);
                if (failOnError == Boolean.TRUE) {
                    this.logger.warn(errorMsg);
                    throw new IOException((Throwable)new MavenExecutionException(errorMsg, model.getPomFile()));
                }
                this.logger.warn(errorMsg);
            }
        }
        return model;
    }

    private String getVersion(Model model) {
        return model.getVersion() == null ? model.getParent().getVersion() : model.getVersion();
    }

    static String getGroupId(Model model) {
        if (model.getGroupId() != null) {
            return model.getGroupId();
        }
        if (model.getParent() != null) {
            return model.getParent().getGroupId();
        }
        return "n/A";
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    static void reset() {
        VersionFactory.version = null;
    }

    public static boolean isVersionOverridden() {
        String version = System.getProperty(MAVENEXT_RELEASE_VERSION);
        return version != null;
    }
}

